/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import org.jetbrains.annotations.NotNull;

public class RemoveMeasurementCommand
extends ProjectCommand {
    private NodeContainer container;

    public RemoveMeasurementCommand(@NotNull Measurement measurement) {
        super(measurement);
    }

    @Override
    public Object execute() {
        Measurement measurement = this.getAffectedObject();
        this.container = measurement.getParentObject();
        try {
            this.container.removeChild(measurement);
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        return null;
    }

    @Override
    public void undo() {
        try {
            this.container.addChild(this.getAffectedObject());
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getAffectedObject().getDefaultLabel();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Measurement getAffectedObject() {
        return (Measurement)super.getAffectedObject();
    }
}

