/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.collections.Sequence;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.RemoveActivityCommand;
import oracle.bpm.project.command.design.RemoveActivityPlainCommand;
import oracle.bpm.project.command.design.RemoveFromGroupPlainCommand;
import oracle.bpm.project.command.design.RemoveTransitionCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;

public class RemoveGroupCommand
extends MultipleCommand {
    private Subprocess subprocess;

    public RemoveGroupCommand(Subprocess subprocess) {
        super(subprocess);
        this.subprocess = subprocess;
        this.buildMultipleCommand();
    }

    public Subprocess getSubprocess() {
        return this.subprocess;
    }

    public String toString() {
        return ProjectCommandMsg.REMOVE.getString();
    }

    private void buildMultipleCommand() {
        this.removeOutgoingTransitions();
        Sequence<FlowNode> list = this.getSubprocess().getFlowNodes();
        for (FlowNode act : list) {
            if (ModelUtils.isSubprocess(act)) {
                this.addCommand(new RemoveGroupCommand((Subprocess)act));
                continue;
            }
            this.addCommand(new RemoveActivityCommand(act));
        }
        if (this.getSubprocess().getSubprocess() != null) {
            this.addCommand(new RemoveFromGroupPlainCommand(this.getSubprocess()));
        }
        this.addCommand(new RemoveActivityPlainCommand(this.getSubprocess()));
    }

    private void removeOutgoingTransitions() {
        Sequence<SequenceFlow> flows = this.getSubprocess().getOutgoingSequenceFlows();
        for (SequenceFlow flow : flows) {
            this.addCommand(new RemoveTransitionCommand(flow));
        }
    }
}

