/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Subprocess;
import org.jetbrains.annotations.NotNull;

public class RemoveFromGroupPlainCommand
extends ProjectCommand {
    @NotNull
    private final FlowNode flowNode;
    @NotNull
    private final Subprocess subprocess;

    public RemoveFromGroupPlainCommand(@NotNull FlowNode flowNode) {
        super(flowNode);
        this.flowNode = flowNode;
        Subprocess subflow = flowNode.getSubprocess();
        if (subflow == null) {
            throw new IllegalStateException("FlowNode has no subprocess to be removed from!");
        }
        this.subprocess = subflow;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.REMOVE_FROM_SCOPE.getString();
    }

    @Override
    public Object execute() {
        try {
            this.subprocess.removeChild(this.flowNode);
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public void undo() {
        try {
            this.subprocess.addChild(this.flowNode);
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
    }
}

