/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.collections.Sequence;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.ChangeTransitionTargetCommand;
import oracle.bpm.project.command.design.RemoveTransitionCommand;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class RemoveAssociatedTransitionsCommand
extends MultipleCommand {
    private FlowNode flowNode;

    public RemoveAssociatedTransitionsCommand(@NotNull FlowNode flowNode) {
        super(new ProjectObject[0]);
        this.flowNode = flowNode;
        this.buildMultipleCommand();
    }

    private void buildMultipleCommand() {
        FlowNode newTarget = null;
        Sequence<SequenceFlow> flows = this.flowNode.getOutgoingSequenceFlows();
        for (SequenceFlow flow : flows) {
            this.addCommand(new RemoveTransitionCommand(flow));
            newTarget = flow.getTarget();
        }
        flows = this.flowNode.getIncomingSequenceFlows();
        for (SequenceFlow flow : flows) {
            if (!ModelUtils.isEndEvent(this.flowNode) && ModelUtils.getSequenceFlowsBetween(flow.getSource(), newTarget).isEmpty() && newTarget != null) {
                this.addCommand(new ChangeTransitionTargetCommand(flow, newTarget));
                continue;
            }
            this.addCommand(new RemoveTransitionCommand(flow));
        }
    }
}

