/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.MoveFlowNodeCommand;
import oracle.bpm.project.command.design.RemoveAssociatedTransitionsCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.project.model.processes.SequenceFlow;
import org.jetbrains.annotations.NotNull;

public class RelocateActivityCommand
extends MultipleCommand {
    private FlowNode flowNode;
    @NotNull
    private Grid grid;
    private Point location;
    private SequenceFlow transition;

    public RelocateActivityCommand(@NotNull FlowNode flowNode, @NotNull Point location, @NotNull SequenceFlow transition, @NotNull Grid grid) {
        super(flowNode);
        this.flowNode = flowNode;
        this.location = location;
        this.transition = transition;
        this.grid = grid;
        this.build();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.flowNode.getLabelMap().getString()).getString();
    }

    private void build() {
        this.addCommand(new RemoveAssociatedTransitionsCommand(this.flowNode));
        this.addCommand(new MoveFlowNodeCommand(this.flowNode, this.location, this.grid, this.transition, true));
    }
}

