/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.project.model.processes.Positional;

public class MoveObjectCommand
extends MultipleCommand {
    private Grid grid;
    private Point location;
    private Positional object;
    private Point prevLocation;

    public MoveObjectCommand(Positional object, Point location, Grid grid) {
        super(object);
        this.object = object;
        this.location = location;
        this.grid = grid;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.object.toString()).getString();
    }

    @Override
    public void undo() {
        this.object.setLocation(this.prevLocation);
    }

    @Override
    public Object execute() throws ExecutionException {
        this.prevLocation = this.object.getLocation();
        Positional positional = this.object;
        if (!positional.isAdjustable() || this.grid != null) {
            // empty if block
        }
        positional.setLocation(this.location);
        return null;
    }
}

