/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.ChangeSequenceFlowRoutingDataCommand;
import oracle.bpm.project.command.design.InsertActivityInTransitionCommand;
import oracle.bpm.project.command.design.MoveObjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Grid;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.RoutingMode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveFlowNodeCommand
extends MultipleCommand {
    private FlowNode flowNode;
    @NotNull
    private Grid grid;
    private Point location;
    private boolean relocate;
    @Nullable
    private SequenceFlow transition;

    public MoveFlowNodeCommand(FlowNode flowNode, Point location, @NotNull Grid grid) {
        this(flowNode, location, grid, null);
    }

    public MoveFlowNodeCommand(FlowNode flowNode, Point location, @NotNull Grid grid, @Nullable SequenceFlow sequenceFlow) {
        this(flowNode, location, grid, sequenceFlow, false);
    }

    public MoveFlowNodeCommand(FlowNode flowNode, Point location, @NotNull Grid grid, @Nullable SequenceFlow transition, boolean relocate) {
        super(flowNode);
        this.flowNode = flowNode;
        this.location = location;
        this.transition = transition;
        this.relocate = relocate;
        this.grid = grid;
        this.build();
    }

    public Point getLocation() {
        return this.location;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.getFlowNode().getLabelMap().getString()).getString();
    }

    private FlowNode getFlowNode() {
        return this.flowNode;
    }

    @Nullable
    private SequenceFlow getTransition() {
        return this.transition;
    }

    private void build() {
        SequenceFlow sequenceFlow;
        this.addCommand(new MoveObjectCommand(this.getFlowNode(), this.getLocation(), this.grid));
        Point delta = this.location.sub(this.getFlowNode().getLocation());
        if (ModelUtils.isSubprocess(this.flowNode)) {
            Subprocess subprocess = this.getFlowNode().asAnyNode(Subprocess.class);
            for (FlowNode flowNode : subprocess.getFlowNodes()) {
                this.addCommand(new MoveFlowNodeCommand(flowNode, flowNode.getLocation().add(delta), this.grid));
            }
            for (Measurement measurement : subprocess.getMeasurements()) {
                this.addCommand(new MoveObjectCommand(measurement, measurement.getLocation().add(delta), this.grid));
            }
            for (SequenceFlow sequenceFlow2 : subprocess.getSequenceFlows()) {
                if (sequenceFlow2.getRoutingMode().equals((Object)RoutingMode.STRAIGHT)) continue;
                this.addCommand(new ChangeSequenceFlowRoutingDataCommand(sequenceFlow2, sequenceFlow2.getRoutingMode(), sequenceFlow2.getControlPoint().add(delta)));
            }
        }
        if (this.getFlowNode().isActivity()) {
            Activity activity = this.getFlowNode().asAnyNode(Activity.class);
            for (BoundaryEvent boundaryEvent : activity.getActivityBoundaryEvents()) {
                this.addCommand(new MoveFlowNodeCommand(boundaryEvent, boundaryEvent.getLocation().add(delta), this.grid));
            }
        }
        if ((sequenceFlow = this.getTransition()) != null && ModelUtils.canBeInsertedInTransition(this.getFlowNode(), sequenceFlow, this.relocate)) {
            this.addCommand(new InsertActivityInTransitionCommand(this.getFlowNode(), sequenceFlow));
        }
    }
}

