/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.lang.exception.CouldNotDeleteResourceException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;

public class DeleteModelSimulationCommand
extends ProjectCommand {
    private Process model;
    private ModelSimulation simulation;

    public DeleteModelSimulationCommand(ModelSimulation simulation) {
        super(new ProjectObject[0]);
        this.simulation = simulation;
        this.model = simulation.getProcess();
    }

    public Process getModel() {
        return this.model;
    }

    public ModelSimulation getSimulation() {
        return this.simulation;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.DELETE.getString();
    }

    @Override
    public Object execute() throws ExecutionException {
        try {
            this.getModel().getProject().getSimulations().removeModelSimulation(this.getModel().getId(), this.getSimulation());
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        catch (CouldNotDeleteResourceException e) {
            MessageDialog.showError((Msg)e.getMsg());
        }
        return null;
    }

    @Override
    public void undo() {
        try {
            this.getModel().getProject().getSimulations().addModelSimulation(this.getModel().getId(), this.getSimulation());
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
    }
}

