/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class AddTransitionCommand
extends ProjectCommand {
    private SequenceFlow transition;

    public AddTransitionCommand(@NotNull SequenceFlow transition) {
        super(transition);
        this.transition = transition;
    }

    public AddTransitionCommand(@NotNull NodeContainer container, FlowNode nodeFrom, FlowNode nodeTo) {
        this(container.createSequenceFlow(nodeFrom, nodeTo));
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(this.transition.getId()).getString();
    }

    @Override
    public Object execute() throws ExecutionException {
        if (this.transition != null) {
            try {
                if (this.transition.getSource() == this.transition.getTarget()) {
                    throw new ProjectException(this.transition, ProjectModelMsg.REFLEXIVE_RELATION_NOT_ALLOWED);
                }
                this.transition.setId(ModelUtils.nextIdForSequenceFlow(this.transition.getProcess()));
                this.transition.getParentObject().addChild(this.transition);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
        }
        return null;
    }

    @Override
    public void undo() {
        if (this.transition != null) {
            try {
                this.transition.getParentObject().removeChild(this.transition);
            }
            catch (ProjectException e) {
                Log.logWarning(e);
            }
        }
    }
}

