/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.log.Log;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.ShiftObjectsCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class AddLaneCommand
extends MultipleCommand {
    private Lane lane;
    private String name;
    private int offset;
    private Process process;
    private boolean rescan;
    private int size;
    private String varName;

    public AddLaneCommand(@NotNull Process process, @NotNull String name, String varName, int offset) {
        this(process, name, varName, offset, 200);
    }

    public AddLaneCommand(@NotNull Process process, @NotNull String name, String varName, int offset, int size) {
        this(process, name, varName, offset, size, true);
    }

    public AddLaneCommand(@NotNull Process process, @NotNull String name, String varName, int offset, int size, boolean rescan) {
        super(new ProjectObject[0]);
        this.process = process;
        this.name = name;
        this.varName = varName;
        this.rescan = rescan;
        this.offset = offset;
        this.size = LaneUtils.calculateMinimunLaneSize(size, name, varName);
        this.build();
    }

    @Override
    public Lane getAffectedObject() {
        return this.lane;
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(this.lane.getId()).getString();
    }

    private void build() {
        if (this.lane == null) {
            this.lane = this.process.createLane(this.name);
            if (!this.lane.isAutomatic()) {
                Role role = this.process.getProject().getOrganization().findRoleById(this.name);
                this.lane.setDefaultLabel(role.getName());
            }
            this.lane.asMutable().setParamName(this.varName);
            this.lane.asMutable().setSize(this.size);
        }
        this.addCommand(new ShiftObjectsCommand(this.process, this.offset + 1, this.lane.getSize(), this.rescan));
        this.addCommand(new ProjectCommand(new ProjectObject[0]){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public Object execute() throws ExecutionException {
                AddLaneCommand.this.lane.asMutable().setOffset(AddLaneCommand.this.offset);
                try {
                    AddLaneCommand.this.lane.getProcess().addChild(AddLaneCommand.this.lane);
                }
                catch (ProjectException e) {
                    throw new ExecutionException(e);
                }
                return null;
            }

            @Override
            public void undo() {
                if (AddLaneCommand.this.lane != null) {
                    try {
                        AddLaneCommand.this.lane.getProcess().removeChild(AddLaneCommand.this.lane);
                    }
                    catch (ProjectException e) {
                        Log.logWarning(e);
                    }
                }
            }
        });
    }
}

