/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.NodeContainer;
import org.jetbrains.annotations.NotNull;

public class AddDataObjectCommand
extends ProjectCommand {
    private DataObject dataObject;

    public AddDataObjectCommand(@NotNull NodeContainer nodeContainer, @NotNull DataObject dataObject) {
        super(nodeContainer);
        this.dataObject = dataObject;
    }

    @Override
    public Object execute() {
        try {
            this.getNodeContainer().addChild(this.dataObject);
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        return this.dataObject;
    }

    @Override
    public void undo() {
        try {
            NodeContainer nodeContainer = this.getNodeContainer();
            if (nodeContainer.findDataObject(this.dataObject.getId()) != null) {
                this.getNodeContainer().removeChild(this.dataObject);
            }
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(this.dataObject.getId()).getString();
    }

    private NodeContainer getNodeContainer() {
        return (NodeContainer)this.getAffectedObject();
    }
}

