/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.geom.Point;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.AddSubprocessCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.NotNull;

public class AddActivityCommand
extends MultipleCommand {
    private Point location;
    private FlowNode node;

    public AddActivityCommand(@NotNull FlowNode node, @NotNull Point destination) {
        super(node.getProcess());
        this.location = destination;
        this.node = node;
        this.build();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.ADD_OBJECT(this.node.getDefaultLabel()).getString();
    }

    private void build() {
        if (ModelUtils.isSubprocess(this.node)) {
            this.node.setLocation(this.location);
            this.addCommand(new AddSubprocessCommand((Subprocess)this.node));
        } else {
            this.addCommand(new InnerAddCommand(this.node, this.location));
        }
    }

    static class InnerAddCommand
    extends ProjectCommand {
        private Point location;
        private FlowNode node;

        public InnerAddCommand(FlowNode node, Point location) {
            super(new ProjectObject[0]);
            this.node = node;
            this.location = location;
        }

        @Override
        public Object execute() throws ExecutionException {
            try {
                this.node.setLocation(this.location);
                this.node.getParentObject().addChild(this.node);
            }
            catch (ProjectException e) {
                throw new ExecutionException(e);
            }
            return null;
        }

        @Override
        public void undo() {
            if (this.node != null) {
                try {
                    this.node.getParentObject().removeChild(this.node);
                }
                catch (ProjectException e) {
                    throw new ExecutionException(e);
                }
            }
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

