/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.shared.events.ChartDataEventArgs;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Point;

public class WebTooltipAppearance
extends ChartAppearance {
    private Color backColor = DefaultConstants.D_TOOLTIP_BACK_COLOR;
    private Color borderColor = DefaultConstants.D_BORDER_COLOR;
    private int borderThickness = DefaultConstants.D_BORDER_THICKNESS;
    private int display = 0;
    private boolean enableFading = false;
    private Font font = DefaultConstants.D_LABEL_FONT;
    private Color fontColor = DefaultConstants.D_TEXT_COLOR;
    private int format = DefaultConstants.D_TOOLTIP_FORMAT;
    private String formatString = DefaultConstants.D_TOOLTIP_FORMAT_DATA;
    private int padding = 0;
    static final long serialCheck = -2447956239362716254L;
    static final long serialVersionUID = 5370777756543128060L;

    public WebTooltipAppearance() {
    }

    public WebTooltipAppearance(IChartComponent component) {
        super(component);
        this.display = 1;
    }

    public int getDisplay() {
        return this.display;
    }

    public void setDisplay(int value) {
        this.display = value;
        this.updateAll(false, true);
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int value) {
        this.format = value;
        this.generateFormatString();
        this.updateAll(false, true);
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String value) {
        this.formatString = value;
        this.format = 4;
        this.updateAll(false, true);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font value) {
        this.font = value;
        this.updateAll(false, true);
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color value) {
        this.fontColor = value;
        this.updateAll(false, true);
    }

    public boolean getEnableFadingEffect() {
        return this.enableFading;
    }

    public void setEnableFadingEffect(boolean value) {
        this.enableFading = value;
    }

    public int getBorderThickness() {
        return this.borderThickness;
    }

    public void setBorderThickness(int value) {
        this.borderThickness = value;
        this.updateAll(false, true);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color value) {
        this.borderColor = value;
        this.updateAll(false, true);
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color value) {
        this.backColor = value;
        this.updateAll(false, true);
    }

    public ChartDataEventArgs getChartInfoFromPoint(int x, int y) {
        if (this.component != null) {
            return this.component.getChartInfoFromPoint(new Point(x, y));
        }
        return null;
    }

    public String toString() {
        return this.display != 0 ? String.valueOf(this.display) : DefaultConstants.D_MISSING_STRING;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int value) {
        this.padding = value;
    }

    @Override
    public boolean shouldSerialize() {
        return this.shouldSerializeBackColor() || this.shouldSerializeBorderColor() || this.shouldSerializeBorderThickness() || this.shouldSerializeDisplay() || this.shouldSerializeEnableFadingEffect() || this.shouldSerializeFont() || this.shouldSerializeFontColor() || this.shouldSerializeFormat() || this.shouldSerializeFormatString() || this.shouldSerializePadding();
    }

    boolean shouldSerializeDisplay() {
        return this.display != 1;
    }

    boolean shouldSerializeFormat() {
        return false;
    }

    boolean shouldSerializeFormatString() {
        return !this.formatString.equals(DefaultConstants.D_TOOLTIP_FORMAT_DATA);
    }

    boolean shouldSerializeFont() {
        return !MiscFunctions.equals(this.font, DefaultConstants.D_LABEL_FONT);
    }

    boolean shouldSerializeFontColor() {
        return !MiscFunctions.equals(this.fontColor, DefaultConstants.D_TEXT_COLOR);
    }

    boolean shouldSerializeEnableFadingEffect() {
        return this.enableFading;
    }

    boolean shouldSerializeBorderThickness() {
        return this.borderThickness != DefaultConstants.D_BORDER_THICKNESS;
    }

    boolean shouldSerializeBorderColor() {
        return !MiscFunctions.equals(this.borderColor, DefaultConstants.D_BORDER_COLOR);
    }

    boolean shouldSerializeBackColor() {
        return !MiscFunctions.equals(this.backColor, DefaultConstants.D_TOOLTIP_BACK_COLOR);
    }

    void generateFormatString() {
        switch (this.format) {
            case 0: {
                this.formatString = "";
                break;
            }
            case 1: {
                this.formatString = DefaultConstants.D_TOOLTIP_FORMAT_DATA;
                break;
            }
            case 2: {
                this.formatString = DefaultConstants.D_TOOLTIP_FORMAT_LABEL_PLUS_DATA;
                break;
            }
            case 3: {
                this.formatString = DefaultConstants.D_TOOLTIP_FORMAT_ROW_COLUMN_PLUS_DATA;
                break;
            }
        }
    }

    boolean shouldSerializePadding() {
        return this.padding != 0;
    }
}

