/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import java.util.Random;
import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;
import oracle.bpm.draw.Font;
import oracle.bpm.ui.FontStyle;

public class ScatterChartAppearance
extends ChartTypeAppearance {
    char character = DefaultConstants.D_SCATTER_CHART_CHARACTER;
    Font characterFont;
    int columnX = DefaultConstants.D_SCATTER_CHART_COLUMN_X;
    int columnY = DefaultConstants.D_SCATTER_CHART_COLUMN_Y;
    boolean connectWithLines = false;
    boolean groupByColumn = false;
    int groupByColumnNumber = DefaultConstants.D_SCATTER_CHART_GROUP_COLUMN;
    int icon = DefaultConstants.D_SCATTER_CHART_ICON;
    int iconSize = DefaultConstants.D_SCATTER_CHART_ICON_SIZE;
    transient int randomStartIcon = 2 + new Random().nextInt(6);
    static final long serialCheck = -4646406020032231191L;
    static final long serialVersionUID = 8290818079482782647L;
    private static final int FONT_SIZE = 31;
    private static final int BOLD = 32;
    private static final int ITALIC = 64;
    private static final int LINES = 128;
    private static final int GROUP_BY_COL = 256;
    private static final int ICON = 9;
    private static final int ICON_SIZE = 13;
    private static final int CHAR = 18;

    public ScatterChartAppearance() {
        this(null);
    }

    public ScatterChartAppearance(IChartComponent component) {
        super(component);
    }

    public ScatterChartAppearance(int columnX, int columnY, int groupByColumnNumber, int flags, String fontName) {
        this(null);
        this.columnX = columnX;
        this.columnY = columnY;
        this.groupByColumnNumber = groupByColumnNumber;
        if (fontName != null) {
            FontStyle style = MiscFunctions.isSet(flags, 32) ? FontStyle.BOLD : (MiscFunctions.isSet(flags, 64) ? FontStyle.ITALIC : FontStyle.PLAIN);
            this.characterFont = Font.valueOf(fontName, style, MiscFunctions.inRange(flags, 0, 31));
        }
        this.icon = MiscFunctions.inRange(flags, 9, 15);
        this.iconSize = MiscFunctions.inRange(flags, 13, 31);
        this.groupByColumn = MiscFunctions.isSet(flags, 256);
        this.connectWithLines = MiscFunctions.isSet(flags, 128);
        if (MiscFunctions.inRange(flags, 18, 65535) != 0) {
            this.character = (char)MiscFunctions.inRange(flags, 18, 65535);
        }
    }

    public static int toFlag(int icon, int iconSize, boolean connectWithLines, boolean groupByColumn, int character, int fontSize, boolean bold, boolean italic) {
        return MiscFunctions.add(icon, 15, 9) | MiscFunctions.add(iconSize, 31, 13) | MiscFunctions.add(connectWithLines, 128) | MiscFunctions.add(groupByColumn, 256) | MiscFunctions.add(character, 65535, 18) | MiscFunctions.add(fontSize, 31, 0) | MiscFunctions.add(bold, 32) | MiscFunctions.add(italic, 64);
    }

    public int firstIcon() {
        return this.icon == 1 ? this.randomStartIcon : this.icon;
    }

    public boolean getConnectWithLines() {
        return this.connectWithLines;
    }

    public void setConnectWithLines(boolean value) {
        this.connectWithLines = value;
        this.updateAll(false, true);
    }

    public int getIcon() {
        return this.icon;
    }

    public void setIcon(int value) {
        if (value == 1) {
            this.randomStartIcon = 2 + new Random().nextInt(6);
        }
        this.icon = value;
        this.updateAll(false, true);
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int value) {
        this.iconSize = value;
        this.updateAll(false, true);
    }

    public char getCharacter() {
        return this.character;
    }

    public void setCharacter(char value) {
        this.character = value;
        this.updateAll(false, true);
    }

    public Font getCharacterFont() {
        return this.characterFont == null ? DefaultConstants.D_SCATTER_CHART_CHARACTER_FONT : this.characterFont;
    }

    public void setCharacterFont(Font value) {
        this.characterFont = value;
        this.updateAll(false, true);
    }

    public boolean getUseGroupByColumn() {
        return this.groupByColumn;
    }

    public void setUseGroupByColumn(boolean value) {
        this.groupByColumn = value;
        this.updateAll(false, true);
    }

    public int getGroupByColumn() {
        return this.groupByColumnNumber;
    }

    public void setGroupByColumn(int value) {
        if (value < 0) {
            value = 0;
        }
        this.groupByColumnNumber = value;
        this.updateAll(false, true);
    }

    public int getColumnX() {
        return this.columnX;
    }

    public void setColumnX(int value) {
        if (value < 0) {
            value = 0;
        }
        this.columnX = value;
        this.updateAll(false, true);
    }

    public int getColumnY() {
        return this.columnY;
    }

    public void setColumnY(int value) {
        if (value < 0) {
            value = 0;
        }
        this.columnY = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.character != DefaultConstants.D_SCATTER_CHART_CHARACTER || !MiscFunctions.equals(this.getCharacterFont(), DefaultConstants.D_SCATTER_CHART_CHARACTER_FONT) || this.icon != DefaultConstants.D_SCATTER_CHART_ICON || this.iconSize != DefaultConstants.D_SCATTER_CHART_ICON_SIZE || this.columnX != DefaultConstants.D_SCATTER_CHART_COLUMN_X || this.columnY != DefaultConstants.D_SCATTER_CHART_COLUMN_Y || this.connectWithLines || this.groupByColumn || this.groupByColumnNumber != DefaultConstants.D_SCATTER_CHART_GROUP_COLUMN;
    }

    @Override
    public void copy(Object sa) {
        if (sa == null || !(sa instanceof ScatterChartAppearance)) {
            return;
        }
        ScatterChartAppearance a = (ScatterChartAppearance)sa;
        if (!MiscFunctions.equals(this.getCharacterFont(), a.getCharacterFont()) || this.character != a.character || this.columnX != a.columnX || this.columnY != a.columnY || this.icon != a.icon || this.iconSize != a.iconSize || this.groupByColumn != a.groupByColumn || this.groupByColumnNumber != a.groupByColumnNumber || this.connectWithLines != a.connectWithLines) {
            this.dirty = true;
        }
        this.characterFont = a.characterFont;
        this.character = a.character;
        this.columnX = a.columnX;
        this.columnY = a.columnY;
        if (this.icon != a.icon && a.icon == 1) {
            this.randomStartIcon = 2 + new Random().nextInt(6);
        }
        this.icon = a.icon;
        this.iconSize = a.iconSize;
        this.groupByColumn = a.groupByColumn;
        this.groupByColumnNumber = a.groupByColumnNumber;
        this.connectWithLines = a.connectWithLines;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

