/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;

public class HeatMapChartAppearance
extends ChartTypeAppearance {
    int renderQuality = DefaultConstants.D_HEAT_MAP_QUALITY;
    int styleOfLines = DefaultConstants.D_HEAT_MAP_LINES;
    static final long serialCheck = 6561040915180691889L;
    static final long serialVersionUID = 659648201553842184L;
    public static final int NONE = 0;
    public static final int LOW_QAUALITY = 1;
    public static final int MEDIUM_QUALITY = 2;
    public static final int HIGH_QUALITY = 3;
    public static final int SUPER_QUALITY = 4;
    public static final int DATA = 1;
    public static final int ALL = 2;

    public HeatMapChartAppearance() {
    }

    public HeatMapChartAppearance(IChartComponent component) {
        super(component);
    }

    public HeatMapChartAppearance(int quality, int lines) {
        this.renderQuality = quality;
        this.styleOfLines = lines & 3;
    }

    public int getStyleOfLines() {
        return this.styleOfLines;
    }

    public void setStyleOfLines(int value) {
        this.styleOfLines = value & 3;
    }

    public int getRenderQuality() {
        return this.renderQuality;
    }

    public void setRenderQuality(int value) {
        this.renderQuality = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.renderQuality != 3 || this.styleOfLines != 1;
    }

    @Override
    public void copy(Object ha) {
        if (ha == null || !(ha instanceof HeatMapChartAppearance)) {
            return;
        }
        HeatMapChartAppearance a = (HeatMapChartAppearance)ha;
        if (this.renderQuality != a.renderQuality || this.styleOfLines != a.styleOfLines) {
            this.dirty = true;
        }
        this.renderQuality = a.renderQuality;
        this.styleOfLines = a.styleOfLines;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

