/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.appearance.AppearanceHelper;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.draw.Color;

public class GridlinesAppearance
extends AppearanceHelper {
    private int alpha = DefaultConstants.D_COLOR_ALPHA;
    private Color color = DefaultConstants.D_AXIS_MAJOR_GRID_LINE_COLOR;
    private int gridType = 0;
    private int lineStyle = DefaultConstants.D_AXIS_MAJOR_GRID_LINE_STYLE;
    private int thickness = DefaultConstants.D_LINE_THICKNESS;
    private boolean ticks = DefaultConstants.D_AXIS_MAJOR_TICKMARK_VISIBLE;
    private boolean visible = DefaultConstants.D_AXIS_MAJOR_GRID_LINE_VISIBLE;
    static final long serialCheck = -5318701145097145059L;
    static final long serialVersionUID = 1526711843797898276L;
    static final int major = 0;
    static final int minor = 1;

    public GridlinesAppearance() {
    }

    public GridlinesAppearance(Color color, int style, int thickness, boolean visible, boolean ticks, int gridType) {
        if (color == null) {
            color = gridType == 0 ? DefaultConstants.D_AXIS_MAJOR_GRID_LINE_COLOR : DefaultConstants.D_AXIS_MINOR_GRID_LINE_COLOR;
        }
        this.color = color;
        if (color != null) {
            this.alpha = color.getAlpha();
        }
        this.lineStyle = style;
        this.thickness = thickness;
        this.visible = visible;
        this.ticks = ticks;
        this.gridType = gridType;
    }

    GridlinesAppearance(ChartAppearance parent, int gridType) {
        super(parent);
        this.gridType = gridType;
        if (gridType == 1) {
            this.visible = DefaultConstants.D_AXIS_MINOR_GRID_LINE_VISIBLE;
            this.color = DefaultConstants.D_AXIS_MINOR_GRID_LINE_COLOR;
            this.lineStyle = DefaultConstants.D_AXIS_MINOR_GRID_LINE_STYLE;
            this.ticks = DefaultConstants.D_AXIS_MINOR_TICKMARK_VISIBLE;
        }
        if (this.color != null) {
            this.alpha = this.color.getAlpha();
        }
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
        this.updateParentProperty();
    }

    public boolean getTickmarksVisible() {
        return this.ticks;
    }

    public void setTickmarksVisible(boolean value) {
        this.ticks = value;
        this.updateAll(true, true);
    }

    public int getDrawStyle() {
        return this.lineStyle;
    }

    public void setDrawStyle(int value) {
        this.lineStyle = value;
        this.updateParentProperty();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        this.color = value;
        this.updateParentProperty();
    }

    public int getLineThickness() {
        return this.thickness;
    }

    public void setLineThickness(int value) {
        this.validatePropertyInt("Thickness", value, 0, DefaultConstants.D_LINE_THICKNESS_MAX);
        this.thickness = value;
        this.updateParentProperty();
    }

    public int getAlphaLevel() {
        return this.alpha;
    }

    public void setAlphaLevel(int value) {
        this.alpha = value & 0xFF;
        this.updateParentProperty();
    }

    public Color getColorWithAlpha() {
        Color c = this.color;
        return c == null || this.alpha == 0 || this.alpha == 255 ? c : Color.valueOf(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
    }

    @Override
    public boolean shouldSerialize() {
        return this.shouldSerializeColor() || this.shouldSerializeDrawStyle() || this.shouldSerializeVisible() || this.shouldSerializeTicks() || this.thickness != DefaultConstants.D_LINE_THICKNESS;
    }

    public void copy(GridlinesAppearance grid) {
        this.gridType = grid.gridType;
        this.visible = grid.visible;
        this.color = grid.color;
        this.thickness = grid.thickness;
        this.lineStyle = grid.lineStyle;
        this.ticks = grid.ticks;
        this.alpha = grid.alpha;
    }

    boolean shouldSerializeVisible() {
        if (this.gridType == 0) {
            return this.visible != DefaultConstants.D_AXIS_MAJOR_GRID_LINE_VISIBLE;
        }
        return this.visible != DefaultConstants.D_AXIS_MINOR_GRID_LINE_VISIBLE;
    }

    boolean shouldSerializeTicks() {
        return this.ticks != (this.gridType == 0 ? DefaultConstants.D_AXIS_MAJOR_TICKMARK_VISIBLE : DefaultConstants.D_AXIS_MINOR_TICKMARK_VISIBLE);
    }

    boolean shouldSerializeDrawStyle() {
        if (this.gridType == 0) {
            return this.lineStyle != DefaultConstants.D_AXIS_MAJOR_GRID_LINE_STYLE;
        }
        return this.lineStyle != DefaultConstants.D_AXIS_MINOR_GRID_LINE_STYLE;
    }

    boolean shouldSerializeColor() {
        if (this.gridType == 0) {
            return !MiscFunctions.equals(this.color, DefaultConstants.D_AXIS_MAJOR_GRID_LINE_COLOR);
        }
        return !MiscFunctions.equals(this.color, DefaultConstants.D_AXIS_MINOR_GRID_LINE_COLOR);
    }
}

