/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;

public class ColumnChartAppearance
extends ChartTypeAppearance {
    int columnSpace = DefaultConstants.D_BAR_COLUMN_CHART_INTER_SPACING;
    int seriaSpace = DefaultConstants.D_BAR_COLUMN_CHART_SERIES_SPACING;
    boolean stack = false;
    int stackStyle = DefaultConstants.D_STACK_STYLE;
    static final long serialCheck = -1818213689512169910L;
    static final long serialVersionUID = 7072377103766600087L;

    public ColumnChartAppearance() {
    }

    public ColumnChartAppearance(IChartComponent component) {
        super(component);
    }

    public ColumnChartAppearance(int colSpacing, int seriesSpacing, int stackingStyle) {
        this.columnSpace = colSpacing;
        this.seriaSpace = seriesSpacing;
        this.stackStyle = stackingStyle;
    }

    public int getColumnSpacing() {
        return this.columnSpace;
    }

    public void setColumnSpacing(int value) {
        this.columnSpace = value;
        this.updateAll(false, true);
    }

    public int getSeriesSpacing() {
        return this.seriaSpace;
    }

    public void setSeriesSpacing(int value) {
        this.seriaSpace = value;
        this.updateAll(false, true);
    }

    public boolean getStack() {
        return this.stack;
    }

    public void setStack(boolean value) {
        this.stack = value;
    }

    public int getStackStyle() {
        return this.stackStyle;
    }

    public void setStackStyle(int value) {
        this.stackStyle = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.columnSpace != DefaultConstants.D_BAR_COLUMN_CHART_INTER_SPACING || this.seriaSpace != DefaultConstants.D_BAR_COLUMN_CHART_SERIES_SPACING || this.stackStyle != DefaultConstants.D_STACK_STYLE;
    }

    @Override
    public void copy(Object ca) {
        if (ca == null || !(ca instanceof ColumnChartAppearance)) {
            return;
        }
        ColumnChartAppearance a = (ColumnChartAppearance)ca;
        if (this.columnSpace != a.columnSpace || this.seriaSpace != a.seriaSpace || a.stackStyle != a.stackStyle) {
            this.dirty = true;
        }
        this.columnSpace = a.columnSpace;
        this.seriaSpace = a.seriaSpace;
        this.stackStyle = a.stackStyle;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }
}

