/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import java.util.Random;
import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.draw.Color;

public class ColorAppearance
extends ChartAppearance {
    public int shadows3D = DefaultConstants.D_COLOR_SHADOWS;
    int alpha = DefaultConstants.D_COLOR_ALPHA;
    boolean antialias = DefaultConstants.D_COLOR_ANTIALIAS;
    boolean colorByRow = DefaultConstants.D_COLOR_BY_ROW;
    Color colorEnd = DefaultConstants.D_COLOR_END;
    int colorModel = DefaultConstants.D_COLOR_MODEL;
    int colorScaling = DefaultConstants.D_COLOR_SCALE;
    Color colorStart = DefaultConstants.D_COLOR_START;
    int depth = DefaultConstants.D_COLOR_SCALE_DEPTH;
    boolean grayscale = false;
    Color[] nullPalette = new Color[]{Color.CYAN, Color.PINK, Color.GREEN, Color.MAGENTA};
    boolean outline = true;
    Color outlineColor = DefaultConstants.D_COLOR_OUTLINE;
    transient Color[] palette;
    transient int[] randomColors;
    transient int[] randomScales;
    static final long serialCheck = 2070439180121912192L;
    static final long serialVersionUID = -5126743814382283393L;
    public static final int MODEL_LINEAR_RANGE = 0;
    public static final int MODEL_LINEAR_RANDOM = 1;
    public static final int MODEL_PURE_RANDOM = 2;
    public static final int MODEL_WIREFRAME = 3;
    public static final int MODEL_CUSTOM_LINEAR = 4;
    public static final int MODEL_CUSTOM_RANDOM = 5;
    public static final int SCALE_NONE = 0;
    public static final int SCALE_INCREASING = 1;
    public static final int SCALE_DECREASING = 2;
    public static final int SCALE_OSCILATING = 3;
    public static final int SCALE_RANDOM = 4;
    public static final int SCALE_DEPTH_SLIGHT = 0;
    public static final int SCALE_DEPTH_NORMAL = 1;
    public static final int SCALE_DEPTH_LARGE = 2;
    public static final int SCALE_DEPTH_LARGEST = 3;
    static transient int NUM = 20;
    private static final int SCALE = 4;
    private static final int ALPHA = 8;
    private static final int DEPTH = 20;
    private static final int SHADOWS = 24;
    private static final int GRAY = 65536;
    private static final int COLOR_BY_ROW = 131072;
    private static final int OUTLINE = 262144;
    private static final int ANTIALIAS = 524288;

    public ColorAppearance() {
        this(null);
    }

    public ColorAppearance(IChartComponent component) {
        super(component);
        this.dirty = true;
    }

    public ColorAppearance(Color startColor, Color endColor, Color lineColor, int flags) {
        this(null);
        this.colorModel = MiscFunctions.inRange(flags, 0, 5);
        this.colorScaling = MiscFunctions.inRange(flags, 4, 4);
        this.outline = MiscFunctions.isSet(flags, 262144);
        this.grayscale = MiscFunctions.isSet(flags, 65536);
        this.colorByRow = MiscFunctions.isSet(flags, 131072);
        this.antialias = MiscFunctions.isSet(flags, 524288);
        this.alpha = MiscFunctions.inRange(flags, 8, 255);
        this.depth = MiscFunctions.inRange(flags, 20, 2);
        if (startColor != null) {
            this.colorStart = startColor;
        }
        this.colorEnd = endColor;
        this.outlineColor = lineColor;
    }

    public static int toFlag(int model, int scale, int depth, int alpha, boolean outline, boolean gray, boolean colorByRow, boolean antialias, int shadows) {
        return MiscFunctions.add(model, 7, 0) | MiscFunctions.add(scale, 7, 4) | MiscFunctions.add(alpha, 255, 8) | MiscFunctions.add(depth, 3, 20) | MiscFunctions.add(outline, 262144) | MiscFunctions.add(gray, 65536) | MiscFunctions.add(colorByRow, 131072) | MiscFunctions.add(antialias, 524288) | MiscFunctions.add(shadows, 7, 24);
    }

    public void setShadows3D(int bottom, int leftBack, int rightBack, int top, int leftFront, int rightFront, int piePerimeter, int pieInnerSlice) {
        this.shadows3D = MiscFunctions.add(bottom + 5, 15, 0) | MiscFunctions.add(leftBack + 5, 15, 4) | MiscFunctions.add(rightBack + 5, 15, 8) | MiscFunctions.add(top + 5, 15, 12) | MiscFunctions.add(leftFront + 5, 15, 16) | MiscFunctions.add(rightFront + 5, 15, 20) | MiscFunctions.add(piePerimeter + 5, 15, 24) | MiscFunctions.add(pieInnerSlice + 5, 15, 28);
        this.updateAll(false, true);
    }

    public int getModelStyle() {
        return this.colorModel;
    }

    public void setModelStyle(int value) {
        this.colorModel = MiscFunctions.inRange(value, 0, 5);
        this.dirty = true;
        this.randomColors = null;
        this.updateAll(false, true);
    }

    public boolean getColorByRow() {
        return this.colorByRow;
    }

    public void setColorByRow(boolean value) {
        if (this.colorByRow == value) {
            return;
        }
        this.colorByRow = value;
        this.dirty = true;
        this.updateAll(false, true);
    }

    public boolean getAntialias() {
        return this.antialias;
    }

    public void setAntialias(boolean value) {
        if (this.antialias == value) {
            return;
        }
        this.antialias = value;
        this.dirty = true;
        this.updateAll(false, true);
    }

    public boolean getOutline() {
        return this.outline;
    }

    public void setOutline(boolean value) {
        if (this.outline == value) {
            return;
        }
        this.outline = value;
        this.dirty = true;
        this.updateAll(false, true);
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color value) {
        if (MiscFunctions.equals(this.outlineColor, value)) {
            return;
        }
        this.outlineColor = value;
        this.dirty = true;
        this.updateAll(false, true);
    }

    public int getScalingDepth() {
        return this.depth;
    }

    public void setScalingDepth(int value) {
        if (this.depth == (value &= 3)) {
            return;
        }
        this.depth = value;
        this.dirty = true;
        this.updateAll(false, true);
    }

    public int getScaling() {
        return this.colorScaling;
    }

    public void setScaling(int value) {
        this.colorScaling = MiscFunctions.inRange(value, 0, 4);
        this.randomScales = null;
        this.dirty = true;
        this.updateAll(false, true);
    }

    public Color getColorBegin() {
        return this.colorStart;
    }

    public void setColorBegin(Color value) {
        if (value == null || MiscFunctions.equals(this.colorStart, value)) {
            return;
        }
        this.randomColors = null;
        this.colorStart = value;
        this.dirty = true;
        this.updateAll(false, true);
    }

    public Color getColorEnd() {
        return this.colorEnd;
    }

    public void setColorEnd(Color value) {
        if (MiscFunctions.equals(this.colorEnd, value)) {
            return;
        }
        this.randomColors = null;
        this.colorEnd = value;
        this.dirty = true;
        this.updateAll(false, true);
    }

    public boolean getGrayscale() {
        return this.grayscale;
    }

    public void setGrayscale(boolean value) {
        if (this.grayscale == value) {
            return;
        }
        this.grayscale = value;
        this.dirty = true;
        this.updateAll(false, true);
    }

    public int getAlphaLevel() {
        return this.alpha;
    }

    public void setAlphaLevel(int value) {
        this.alpha = value &= 0xFF;
        this.dirty = true;
        this.randomColors = null;
        this.updateAll(false, true);
    }

    public Color[] getCustomPalette() {
        return this.palette == null ? this.nullPalette : this.palette;
    }

    public void setCustomPalette(Color[] value) {
        int i;
        if (value != null && (i = value.length) > 0) {
            Color c = value[0];
            if (c == null) {
                c = Color.WHITE;
            } else {
                while (i-- > 0) {
                    if (value[i] != null) continue;
                    value[i] = c;
                }
            }
        }
        this.palette = value;
        this.dirty = true;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.colorModel != DefaultConstants.D_COLOR_MODEL || this.colorScaling != DefaultConstants.D_COLOR_SCALE || !MiscFunctions.equals(DefaultConstants.D_COLOR_START, this.colorStart) || !MiscFunctions.equals(DefaultConstants.D_COLOR_END, this.colorEnd) || !MiscFunctions.equals(DefaultConstants.D_COLOR_OUTLINE, this.outlineColor) || !this.outline || this.grayscale || this.alpha != DefaultConstants.D_COLOR_ALPHA || this.palette != null || this.colorByRow != DefaultConstants.D_COLOR_BY_ROW || this.antialias != DefaultConstants.D_COLOR_ANTIALIAS || this.depth != DefaultConstants.D_COLOR_SCALE_DEPTH || this.shadows3D != DefaultConstants.D_COLOR_SHADOWS;
    }

    @Override
    public void copy(Object ca) {
        if (ca == null || !(ca instanceof ColorAppearance)) {
            return;
        }
        ColorAppearance a = (ColorAppearance)ca;
        if (!(this.colorModel == a.colorModel && this.colorScaling == a.colorScaling && MiscFunctions.equals(this.colorEnd, a.colorEnd) && MiscFunctions.equals(this.colorStart, a.colorStart) && MiscFunctions.equals(this.outlineColor, a.outlineColor) && this.outline == a.outline && this.grayscale == a.grayscale && this.alpha == a.alpha && this.palette == a.palette && this.antialias == a.antialias && this.colorByRow == a.colorByRow && this.depth == a.depth)) {
            this.dirty = true;
        }
        this.colorModel = a.colorModel;
        this.colorScaling = a.colorScaling;
        this.colorStart = a.colorStart;
        this.colorEnd = a.colorEnd;
        this.outlineColor = a.outlineColor;
        this.outline = a.outline;
        this.grayscale = a.grayscale;
        this.alpha = a.alpha;
        this.palette = a.palette;
        this.antialias = a.antialias;
        this.colorByRow = a.colorByRow;
        this.depth = a.depth;
        this.randomColors = a.randomColors;
        this.randomScales = a.randomScales;
        this.shadows3D = a.shadows3D;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }

    public int[] getRandomColors() {
        if (this.randomColors == null) {
            Random rnd = new Random();
            Color c = this.colorEnd;
            if (c == null) {
                c = this.colorStart;
            }
            this.randomColors = new int[NUM];
            int r0 = this.colorStart.getRed();
            int g0 = this.colorStart.getGreen();
            int b0 = this.colorStart.getBlue();
            for (int i = 0; i < NUM; ++i) {
                int b;
                int g;
                int r;
                if (this.colorModel == 2) {
                    r = rnd.nextInt(255);
                    g = rnd.nextInt(255);
                    b = rnd.nextInt(255);
                } else {
                    int j = rnd.nextInt(NUM);
                    r = r0 + j * (c.getRed() - r0) / NUM;
                    g = g0 + j * (c.getGreen() - g0) / NUM;
                    b = b0 + j * (c.getBlue() - b0) / NUM;
                }
                this.randomColors[i] = r << 16 | g << 8 | b;
            }
        }
        return this.randomColors;
    }

    public int[] getRandomScales() {
        if (this.randomScales == null) {
            Random rnd = new Random();
            this.randomScales = new int[NUM];
            for (int i = 0; i < NUM; ++i) {
                this.randomScales[i] = NUM - rnd.nextInt(NUM * 2);
            }
        }
        return this.randomScales;
    }
}

