/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.AxisAppearance;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;
import oracle.bpm.draw.Color;

public class ChartGridAppearance
extends ChartTypeAppearance {
    AxisAppearance axisX;
    AxisAppearance axisY;
    AxisAppearance axisZ;
    Color backColor = DefaultConstants.D_3D_AXIS_BACK_COLOR;
    String linearFormat = DefaultConstants.D_AXIS_LABEL_FORMAT_DATA;
    static final long serialCheck = 13402762004477229L;
    static final long serialVersionUID = 1811676979995085703L;

    public ChartGridAppearance() {
        this.axisX = new AxisAppearance();
        this.axisY = new AxisAppearance();
        this.axisZ = new AxisAppearance();
    }

    public ChartGridAppearance(IChartComponent component) {
        super(component);
        this.axisX = new AxisAppearance(component, 0);
        this.axisY = new AxisAppearance(component, 1);
        this.axisZ = new AxisAppearance(component, 2);
    }

    public ChartGridAppearance(AxisAppearance x, AxisAppearance y, AxisAppearance z) {
        this.axisX = x != null ? x : new AxisAppearance();
        this.axisY = y != null ? y : new AxisAppearance();
        this.axisZ = z != null ? z : new AxisAppearance();
    }

    public ChartGridAppearance(AxisAppearance x, AxisAppearance y, AxisAppearance z, Color c) {
        this(x, y, z);
        this.backColor = c;
    }

    public AxisAppearance getX() {
        if (this.axisX == null) {
            this.axisX = new AxisAppearance(this.component, 0);
        }
        this.axisX.component = this.component;
        this.axisX.axisNumber = 0;
        return this.axisX;
    }

    public void setX(AxisAppearance value) {
        this.axisX = value;
        this.updateAll(false, true);
    }

    public AxisAppearance getY() {
        if (this.axisY == null) {
            this.axisY = new AxisAppearance(this.component, 1);
        }
        this.axisY.component = this.component;
        this.axisY.axisNumber = 1;
        return this.axisY;
    }

    public void setY(AxisAppearance value) {
        this.axisY = value;
        this.updateAll(false, true);
    }

    public AxisAppearance getZ() {
        if (this.axisZ == null) {
            this.axisZ = new AxisAppearance(this.component, 2);
        }
        this.axisZ.component = this.component;
        this.axisZ.axisNumber = 2;
        return this.axisZ;
    }

    public void setZ(AxisAppearance value) {
        this.axisZ = value;
        this.updateAll(false, true);
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color value) {
        this.backColor = value;
        this.updateAll(false, true);
    }

    public String getDefaultLinearAxisFormat() {
        return this.linearFormat;
    }

    public void setDefaultLinearAxisFormat(String value) {
        if (value != null) {
            this.linearFormat = value;
        }
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.axisX.shouldSerialize() || this.axisY.shouldSerialize() || this.axisZ.shouldSerialize() || !MiscFunctions.equals(this.backColor, DefaultConstants.D_3D_AXIS_BACK_COLOR) || !MiscFunctions.equals(this.linearFormat, DefaultConstants.D_AXIS_LABEL_FORMAT_DATA);
    }

    @Override
    public void copy(Object ca) {
        if (ca == null || !(ca instanceof ChartGridAppearance)) {
            return;
        }
        ChartGridAppearance a = (ChartGridAppearance)ca;
        this.backColor = a.backColor;
        this.linearFormat = a.linearFormat;
        this.axisX.copy(a.axisX);
        this.axisY.copy(a.axisY);
        this.axisZ.copy(a.axisZ);
    }
}

