/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.draw.Color;
import oracle.bpm.ui.Image;

public class BackgroundAppearance
extends ChartAppearance {
    Color color = DefaultConstants.D_CHART_BACK_COLOR;
    transient Image image;
    String imagePath = DefaultConstants.D_BACK_IMAGE_PATH;
    int imageStyle = DefaultConstants.D_BACK_IMAGE_STYLE;
    static final long serialCheck = 1614444076007457032L;
    static final long serialVersionUID = -45210123919174008L;

    public BackgroundAppearance() {
    }

    public BackgroundAppearance(IChartComponent component) {
        super(component);
    }

    public BackgroundAppearance(Color color, String image, int style) {
        this.color = color;
        if (image != null) {
            this.imagePath = image;
        }
        this.imageStyle = style;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        if (MiscFunctions.equals(this.color, value)) {
            return;
        }
        this.color = value;
        this.updateAll(false, true);
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String value) {
        if (value == null) {
            value = "";
        }
        if (MiscFunctions.equals(this.imagePath, value = value.trim())) {
            return;
        }
        this.imagePath = value;
        this.updateAll(false, true);
    }

    public int getImageStyle() {
        return this.imageStyle;
    }

    public void setImageStyle(int value) {
        if (this.imageStyle == value) {
            return;
        }
        this.imageStyle = value;
        this.updateAll(false, true);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image value) {
        if (this.image == value) {
            return;
        }
        this.image = value;
        this.updateAll(false, true);
    }

    @Override
    public boolean shouldSerialize() {
        return !MiscFunctions.equals(this.color, DefaultConstants.D_CHART_BACK_COLOR) || !MiscFunctions.equals(this.imagePath, "") || this.image != null || this.imageStyle != 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BackgroundAppearance)) {
            return false;
        }
        return MiscFunctions.equals(this.color, ((BackgroundAppearance)obj).color) && MiscFunctions.equals(this.imagePath, ((BackgroundAppearance)obj).imagePath) && MiscFunctions.equals(this.image, ((BackgroundAppearance)obj).image) && this.imageStyle == ((BackgroundAppearance)obj).imageStyle;
    }

    @Override
    public void copy(Object ba) {
        if (ba == null || !(ba instanceof BackgroundAppearance)) {
            return;
        }
        BackgroundAppearance a = (BackgroundAppearance)ba;
        if (!this.equals(a)) {
            this.dirty = true;
        }
        this.color = a.color;
        this.imagePath = a.imagePath;
        this.imageStyle = a.imageStyle;
        this.image = a.image;
        if (this.dirty) {
            this.updateAll(false, true);
        }
    }

    public int hashCode() {
        int result = this.color != null ? this.color.hashCode() : 0;
        result = 31 * result + (this.image != null ? this.image.hashCode() : 0);
        result = 31 * result + (this.imagePath != null ? this.imagePath.hashCode() : 0);
        result = 31 * result + this.imageStyle;
        return result;
    }
}

