/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.appearance.AppearanceHelper;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;

public class AxisLabelAppearance
extends AppearanceHelper {
    int axisNumber;
    Color color = DefaultConstants.D_AXIS_LABEL_COLOR;
    Font font = DefaultConstants.D_AXIS_LABEL_FONT;
    int orientation = DefaultConstants.D_AXIS_X_LABEL_ORIENTATION;
    int seriesOrientation = 1;
    boolean visible = true;
    private int itemFormat = 4;
    private String itemFormatString = DefaultConstants.D_AXIS_LABEL_FORMAT_DATA;
    private int seriesFormat = 2;
    private String seriesFormatString = DefaultConstants.D_AXIS_LABEL_FORMAT_SERIES;
    static final long serialCheck = 3124159873574919273L;
    static final long serialVersionUID = -7120091759151757426L;

    public AxisLabelAppearance() {
    }

    public AxisLabelAppearance(Font font, Color fColor, int itemOrientation, int seriesOrientation, int axisNumber, boolean visible) {
        this();
        if (font != null) {
            this.font = font;
        }
        if (fColor != null) {
            this.color = fColor;
        }
        this.orientation = itemOrientation;
        this.seriesOrientation = seriesOrientation;
        this.axisNumber = (axisNumber & 3) % 3;
        this.visible = visible;
    }

    AxisLabelAppearance(ChartAppearance parent, int axisNumber) {
        super(parent);
        this.axisNumber = axisNumber;
        this.orientation = axisNumber == 1 ? DefaultConstants.D_AXIS_Y_LABEL_ORIENTATION : DefaultConstants.D_AXIS_X_LABEL_ORIENTATION;
        this.seriesOrientation = axisNumber == 1 ? 1 : 0;
    }

    public int getAxisNumber() {
        return this.axisNumber;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
        this.updateParentProperty();
    }

    public int getItemFormat() {
        return this.itemFormat;
    }

    public void setItemFormat(int value) {
        this.itemFormat = value;
        this.generateItemFormatString();
        this.updateParentProperty();
    }

    public String getItemFormatString() {
        return this.itemFormatString;
    }

    public void setItemFormatString(String value) {
        this.itemFormatString = value;
        this.itemFormat = 4;
        this.updateParentProperty();
    }

    public int getSeriesFormat() {
        return this.seriesFormat;
    }

    public void setSeriesFormat(int value) {
        this.seriesFormat = value;
        this.generateSeriesFormatString();
        this.updateParentProperty();
    }

    public String getSeriesFormatString() {
        return this.seriesFormatString;
    }

    public void setSeriesFormatString(String value) {
        this.seriesFormatString = value;
        this.seriesFormat = 2;
        this.updateParentProperty();
    }

    public Font getFont() {
        return this.font == null ? DefaultConstants.D_AXIS_LABEL_FONT : this.font;
    }

    public void setFont(Font value) {
        this.font = value;
        this.updateParentProperty();
    }

    public Color getFontColor() {
        return this.color == null ? DefaultConstants.D_AXIS_LABEL_COLOR : this.color;
    }

    public void setFontColor(Color value) {
        this.color = value;
        this.updateParentProperty();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int value) {
        this.orientation = value;
        this.updateParentProperty();
    }

    public int getSeriesOrientation() {
        return this.seriesOrientation;
    }

    public void setSeriesOrientation(int value) {
        this.seriesOrientation = value;
        this.updateParentProperty();
    }

    @Override
    public boolean shouldSerialize() {
        return !MiscFunctions.equals(this.getFont(), DefaultConstants.D_AXIS_LABEL_FONT) || !this.visible || !MiscFunctions.equals(this.getFontColor(), DefaultConstants.D_AXIS_LABEL_COLOR) || this.shouldSerializeSeriesOrientation() || this.shouldSerializeOrientation();
    }

    @Override
    public void copy(Object app) {
        if (!(app instanceof AxisLabelAppearance)) {
            return;
        }
        AxisLabelAppearance appr = (AxisLabelAppearance)app;
        this.orientation = appr.orientation;
        this.font = appr.font;
        this.color = appr.color;
        this.itemFormat = appr.itemFormat;
        this.seriesFormat = appr.seriesFormat;
        this.itemFormatString = appr.itemFormatString;
        this.seriesFormatString = appr.seriesFormatString;
        this.visible = appr.visible;
        this.axisNumber = appr.axisNumber;
        this.seriesOrientation = appr.seriesOrientation;
    }

    boolean shouldSerializeOrientation() {
        return this.orientation != (this.axisNumber == 1 ? DefaultConstants.D_AXIS_Y_LABEL_ORIENTATION : DefaultConstants.D_AXIS_X_LABEL_ORIENTATION);
    }

    boolean shouldSerializeSeriesOrientation() {
        return this.seriesOrientation != (this.axisNumber == 1 ? 1 : 0);
    }

    void generateItemFormatString() {
        switch (this.itemFormat) {
            case 1: {
                this.itemFormatString = DefaultConstants.D_AXIS_LABEL_FORMAT_ITEM;
                break;
            }
            case 2: {
                this.itemFormatString = DefaultConstants.D_AXIS_LABEL_FORMAT_DATA;
                break;
            }
            case 3: {
                this.itemFormatString = DefaultConstants.D_AXIS_LABEL_FORMAT_ITEM_DATA;
                break;
            }
            case 0: {
                this.itemFormatString = "";
                break;
            }
        }
    }

    void generateSeriesFormatString() {
        switch (this.seriesFormat) {
            case 1: {
                this.seriesFormatString = DefaultConstants.D_AXIS_LABEL_FORMAT_SERIES;
                break;
            }
            case 0: {
                this.seriesFormatString = "";
                break;
            }
        }
    }
}

