/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.resources.appearance;

import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.AxisLabelAppearance;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.GridlinesAppearance;
import oracle.bpm.draw.Color;

public class AxisAppearance
extends ChartAppearance {
    public int axisNumber = 0;
    private boolean axisVisible = true;
    private int drawStyle = DefaultConstants.D_AXIS_DEFAULT_LINE_STYLE;
    private AxisLabelAppearance labelAppearance;
    private Color lineColor = DefaultConstants.D_TEXT_COLOR;
    private int lineThickness = DefaultConstants.D_AXIS_THICKNESS;
    private GridlinesAppearance majorGridLines;
    private GridlinesAppearance minorGridLines;
    private double tickInterval = DefaultConstants.D_AXIS_TICK_INTERVAL;
    private double tickPercentage = DefaultConstants.D_AXIS_TICK_PERCENTAGE;
    private int tickStyle = DefaultConstants.D_AXIS_TICK_STYLE;
    private int widthOrHeight = DefaultConstants.D_AXIS_EXTENT;
    static final long serialCheck = 1871606292363087048L;
    static final long serialVersionUID = 509230649154132912L;

    public AxisAppearance() {
    }

    public AxisAppearance(IChartComponent component, int axisNumber) {
        super(component);
        this.axisNumber = axisNumber;
    }

    public AxisAppearance(int extent, AxisLabelAppearance labels, Color lineColor, int lineStyle, int thickness, GridlinesAppearance major, GridlinesAppearance minor, int tickStyle, int tickInterval) {
        this.widthOrHeight = extent;
        this.labelAppearance = labels;
        if (this.labelAppearance != null) {
            this.axisNumber = labels.axisNumber;
        }
        this.lineColor = lineColor != null ? lineColor : DefaultConstants.D_TEXT_COLOR;
        this.drawStyle = lineStyle;
        this.lineThickness = thickness;
        this.majorGridLines = major;
        this.minorGridLines = minor;
        this.tickStyle = tickStyle & 1;
        this.tickPercentage = tickInterval;
    }

    public boolean getVisible() {
        return this.axisVisible;
    }

    public void setVisible(boolean value) {
        this.axisVisible = value;
        this.updateAll(true, true);
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int value) {
        this.validatePropertyInt("Thickness", value, 0, DefaultConstants.D_LINE_THICKNESS_MAX);
        this.lineThickness = value;
        this.updateAll(false, true);
    }

    public int getLineDrawStyle() {
        return this.drawStyle;
    }

    public void setLineDrawStyle(int value) {
        if (value < 0 || value > 4) {
            value = DefaultConstants.D_AXIS_DEFAULT_LINE_STYLE;
        }
        this.drawStyle = value;
        this.updateAll(false, true);
    }

    public GridlinesAppearance getMajorGridLines() {
        if (this.majorGridLines == null) {
            this.majorGridLines = new GridlinesAppearance(this, 0);
        }
        this.majorGridLines.component = this.component;
        return this.majorGridLines;
    }

    public void setMajorGridLines(GridlinesAppearance value) {
        this.majorGridLines = value;
        this.getMajorGridLines().setParentAppearance(this);
        this.updateAll(false, true);
    }

    public GridlinesAppearance getMinorGridLines() {
        if (this.minorGridLines == null) {
            this.minorGridLines = new GridlinesAppearance(this, 1);
        }
        this.minorGridLines.component = this.component;
        return this.minorGridLines;
    }

    public void setMinorGridLines(GridlinesAppearance value) {
        this.minorGridLines = value;
        this.getMinorGridLines().setParentAppearance(this);
        this.updateAll(false, true);
    }

    public int getTickmarkStyle() {
        return this.tickStyle;
    }

    public void setTickmarkStyle(int value) {
        this.tickStyle = value & 1;
        this.updateAll(false, true);
    }

    public double getTickmarkPercentage() {
        return this.tickPercentage;
    }

    public void setTickmarkPercentage(double value) {
        if (value > 100.0) {
            value = 100.0;
        }
        if (value < 1.0) {
            value = 1.0;
        }
        this.tickPercentage = value;
        this.updateAll(false, true);
    }

    public double getTickmarkInterval() {
        return this.tickInterval;
    }

    public void setTickmarkInterval(double value) {
        this.tickInterval = value;
        this.updateAll(false, true);
    }

    public int getExtent() {
        return this.widthOrHeight;
    }

    public void setExtent(int value) {
        if (value > DefaultConstants.D_AXIS_EXTENT_MAX) {
            value = DefaultConstants.D_AXIS_EXTENT_MAX;
        }
        this.widthOrHeight = value;
        this.updateAll(true, true);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color value) {
        this.lineColor = value;
        this.updateAll(false, true);
    }

    public AxisLabelAppearance getLabels() {
        if (this.labelAppearance == null) {
            this.labelAppearance = new AxisLabelAppearance(this, this.axisNumber);
        }
        this.labelAppearance.component = this.component;
        this.labelAppearance.axisNumber = this.axisNumber;
        return this.labelAppearance;
    }

    public void setLabels(AxisLabelAppearance value) {
        this.labelAppearance = value;
        this.getLabels().setParentAppearance(this);
        this.updateAll(true, true);
    }

    @Override
    public boolean shouldSerialize() {
        return this.widthOrHeight != DefaultConstants.D_AXIS_EXTENT || !MiscFunctions.equals(this.lineColor, DefaultConstants.D_TEXT_COLOR) || this.drawStyle != DefaultConstants.D_AXIS_DEFAULT_LINE_STYLE || this.lineThickness != DefaultConstants.D_AXIS_THICKNESS || this.tickPercentage != DefaultConstants.D_AXIS_TICK_PERCENTAGE || this.getMinorGridLines().shouldSerialize() || this.getMajorGridLines().shouldSerialize() || this.tickPercentage != DefaultConstants.D_AXIS_TICK_PERCENTAGE || this.tickStyle != DefaultConstants.D_AXIS_TICK_STYLE || !this.axisVisible || this.getLabels().shouldSerialize();
    }

    @Override
    public void copy(Object appr) {
        if (appr == null || !(appr instanceof AxisAppearance)) {
            return;
        }
        AxisAppearance a = (AxisAppearance)appr;
        this.axisNumber = a.axisNumber;
        this.lineThickness = a.getLineThickness();
        this.drawStyle = a.getLineDrawStyle();
        this.majorGridLines = new GridlinesAppearance();
        this.majorGridLines.copy(a.getMajorGridLines());
        this.minorGridLines = new GridlinesAppearance();
        this.minorGridLines.copy(a.getMinorGridLines());
        this.tickStyle = a.getTickmarkStyle();
        this.tickPercentage = a.getTickmarkPercentage();
        this.tickInterval = a.getTickmarkInterval();
        this.widthOrHeight = a.getExtent();
        this.lineColor = a.lineColor;
        this.labelAppearance = new AxisLabelAppearance();
        this.labelAppearance.copy(a.getLabels());
    }
}

