/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.data;

import java.util.ArrayList;
import java.util.Date;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.data.DataViewToChartAdapter;
import oracle.bpm.chart.data.IChartData;
import oracle.bpm.chart.data.IChartDataFilter;

public class ChartDataFilter
extends ChartDataAdapter
implements IChartDataFilter {
    int[] colTypes;
    String[] columnLabelArray;
    String[] rowLabelArray;
    boolean swapRowsAndColumns = false;
    private ArrayList<Integer> columns = new ArrayList();
    private ArrayList<Integer> rows = new ArrayList();
    private static final int BAD_TYPE = 10;

    public ChartDataFilter(IChartData connectTo) {
        if (connectTo == null) {
            throw new IllegalArgumentException("Null is not allowed");
        }
        this.data = connectTo;
    }

    @Override
    public IChartData getRawData() {
        return (IChartData)this.data;
    }

    @Override
    public int getRealRowNumber(int index) {
        return this.swapRowsAndColumns ? this.realCol(index) : this.realRow(index);
    }

    @Override
    public int getRealColumnNumber(int index) {
        return this.swapRowsAndColumns ? this.realRow(index) : this.realCol(index);
    }

    @Override
    public int getFilteredRowNumber(int index) {
        if (this.swapRowsAndColumns) {
            for (int i = 0; i < this.columns.size(); ++i) {
                int id = this.col(i);
                if (id == index) {
                    return i;
                }
                if (id <= index) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < this.rows.size(); ++i) {
                int id = this.row(i);
                if (id == index) {
                    return i;
                }
                if (id <= index) {
                    continue;
                }
                break;
            }
        }
        return -1;
    }

    @Override
    public int getFilteredColumnNumber(int index) {
        if (!this.swapRowsAndColumns) {
            for (int i = 0; i < this.columns.size(); ++i) {
                int id = this.col(i);
                if (id == index) {
                    return i;
                }
                if (id <= index) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < this.rows.size(); ++i) {
                int id = this.row(i);
                if (id == index) {
                    return i;
                }
                if (id <= index) {
                    continue;
                }
                break;
            }
        }
        return -1;
    }

    @Override
    public boolean getZeroAlignment() {
        return this.zeroAligned;
    }

    @Override
    public int getRowCount() {
        return this.swapRowsAndColumns ? this.columns.size() : this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.swapRowsAndColumns ? this.rows.size() : this.columns.size();
    }

    @Override
    public Object getObjectValue(int row, int column) {
        if (this.swapRowsAndColumns) {
            return this.getRawData().getObjectValue(this.realRow(column), this.realCol(row));
        }
        return this.getRawData().getObjectValue(this.realRow(row), this.realCol(column));
    }

    @Override
    public String getRowLabel(int row) {
        if (this.swapRowsAndColumns) {
            if (this.columnLabelArray != null) {
                return this.columnLabelArray[row % this.columnLabelArray.length];
            }
            return this.getRawData().getColumnLabel(this.realCol(row));
        }
        if (this.rowLabelArray != null) {
            return this.rowLabelArray[row % this.rowLabelArray.length];
        }
        return this.getRawData().getRowLabel(this.realRow(row));
    }

    @Override
    public String getColumnLabel(int column) {
        if (this.swapRowsAndColumns) {
            if (this.rowLabelArray != null) {
                return this.rowLabelArray[column % this.rowLabelArray.length];
            }
            return this.getRawData().getRowLabel(this.realRow(column));
        }
        if (this.columnLabelArray != null) {
            return this.columnLabelArray[column % this.columnLabelArray.length];
        }
        return this.getRawData().getColumnLabel(this.realCol(column));
    }

    public int getRawColumnType(int col) {
        Class cls;
        int iCols = this.getRawData().getColumnCount();
        if (col >= iCols) {
            return 0;
        }
        int i = iCols;
        int stringCol = this.getRowLabelsColumn();
        if (!this.getUseRowLabels()) {
            stringCol = -1;
        } else if (stringCol < 0 || stringCol >= iCols) {
            stringCol = -2;
        }
        if (this.colTypes == null || this.colTypes.length != iCols) {
            this.getRawData().setUseRowLabels(false);
            this.colTypes = new int[iCols];
            while (i-- > 0) {
                this.colTypes[i] = -1;
            }
        }
        int type = 0;
        if (col == stringCol) {
            type = 2;
        } else if (this.data instanceof DataViewToChartAdapter && (cls = ((DataViewToChartAdapter)this.data).getData().getColumnClass(col)) != null && cls != Object.class) {
            if (Number.class.isAssignableFrom(cls)) {
                type = 1;
            } else if (Date.class.isAssignableFrom(cls)) {
                type = 3;
            } else if (String.class.isAssignableFrom(cls)) {
                type = 2;
            }
        }
        if (type == 0) {
            int iRows = this.rows.size();
            for (i = 0; i < iRows; ++i) {
                Object o = this.getRawData().getObjectValue(this.row(i), col);
                if (o == null) continue;
                if (o instanceof Date) {
                    type = 3;
                    break;
                }
                if (o instanceof Number) {
                    type = 1;
                    break;
                }
                if (o instanceof String) {
                    if (type == 2 || ((String)o).length() < 1) continue;
                    try {
                        Double.valueOf((String)o);
                        type = 4;
                    }
                    catch (Exception e) {
                        type = 2;
                    }
                    continue;
                }
                type = 10;
                break;
            }
        }
        if (type == 0) {
            type = 1;
        }
        if (type == 10) {
            type = 0;
        }
        if (type == 4) {
            if (stringCol == -2) {
                type = 2;
                this.rowLabelsColumn = col;
            } else {
                type = 1;
            }
        }
        if (type == 2 && stringCol != -1 && !this.getRawData().getUseRowLabels()) {
            this.getRawData().setRowLabelsColumn(col);
            this.getRawData().setUseRowLabels(true);
        }
        this.colTypes[col] = type;
        return type;
    }

    @Override
    public boolean getSwapRowsAndColumns() {
        return this.swapRowsAndColumns;
    }

    @Override
    public void setSwapRowsAndColumns(boolean swap) {
        this.swapRowsAndColumns = swap;
    }

    @Override
    public void resetColumnList() {
        this.dataMax = Double.NaN;
        this.colTypes = null;
        this.columns.clear();
        this.rows.clear();
    }

    @Override
    public void includeRow(int realRowNum) {
        this.rows.add(realRowNum);
        this.dataMax = Double.NaN;
    }

    @Override
    public void includeColumn(int realColumnNum, boolean include) {
        int i = -1;
        int iSize = this.columns.size();
        while (++i < iSize) {
            int id = this.col(i);
            if (id == realColumnNum) {
                if (!include) {
                    this.columns.remove(i);
                    this.dataMax = Double.NaN;
                }
                return;
            }
            if (id <= realColumnNum) continue;
            if (!include) {
                return;
            }
            --i;
            break;
        }
        if (!include) {
            return;
        }
        if (i >= iSize) {
            this.columns.add(realColumnNum);
        } else {
            this.columns.add(i, realColumnNum);
        }
        this.dataMax = Double.NaN;
    }

    @Override
    public boolean isColumnIncluded(int realColumnNum) {
        for (int i = 0; i < this.columns.size(); ++i) {
            int id = this.col(i);
            if (id == realColumnNum) {
                return true;
            }
            if (id <= realColumnNum) continue;
            return false;
        }
        return false;
    }

    public void setRowLabels(String[] labels) {
        this.rowLabelArray = labels;
    }

    public String[] getRowLabels() {
        return this.rowLabelArray;
    }

    public void setColumnLabels(String[] labels) {
        this.columnLabelArray = labels;
    }

    @Override
    public void setRowLabelsColumn(int column) {
        if (column < this.columns.size()) {
            column = -1;
        }
        this.rowLabelsColumn = column;
    }

    int realRow(int index) {
        return index >= 0 && index < this.rows.size() ? this.row(index) : -1;
    }

    int realCol(int index) {
        return index >= 0 && index < this.columns.size() ? this.col(index) : -1;
    }

    int col(int i) {
        return this.columns.get(i);
    }

    int row(int i) {
        return this.rows.get(i);
    }

    @Override
    boolean checkCol(int col, int type) {
        col = this.col(col);
        if (this.colTypes == null || this.colTypes.length < col || col < 0) {
            return false;
        }
        int colType = this.colTypes[col];
        if (colType < 0) {
            colType = this.getRawColumnType(col);
        }
        return colType == type;
    }
}

