/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.data;

import java.util.List;
import oracle.bpm.chart.data.ArrayToChartAdapter;
import oracle.bpm.chart.data.DataTableToChartAdapter;
import oracle.bpm.chart.data.DataViewToChartAdapter;
import oracle.bpm.chart.data.IChartData;
import oracle.bpm.chart.data.IListToChartAdapter;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;

public abstract class ChartDataAdapter
implements IChartData {
    public Object minValue;
    public Object maxValue;
    Object data;
    double dataMax;
    double[] dataMaxColumn;
    double[] dataMaxRow;
    double dataMin = Double.NaN;
    double[] dataMinColumn;
    double[] dataMinRow;
    int rowLabelsColumn = -1;
    boolean useRowLabel = false;
    boolean zeroAligned = true;
    public static final int NONE = 0;
    public static final int NUMBER = 1;
    public static final int STRING = 2;
    public static final int DATE = 3;
    static final int STRING_NUMBER = 4;

    public ChartDataAdapter() {
        this.dataMax = Double.NaN;
    }

    @Override
    public abstract int getRowCount();

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract Object getObjectValue(int var1, int var2);

    public static IChartData createAdapter(Object data) {
        if (data instanceof List) {
            return new IListToChartAdapter((List)data);
        }
        if (data instanceof TableModel) {
            return new DataViewToChartAdapter((TableModel)data);
        }
        if (data instanceof Table) {
            return new DataTableToChartAdapter((Table)data);
        }
        return new ArrayToChartAdapter(data instanceof Object[] ? (Object[])data : new Object[]{});
    }

    public static boolean isValid(Object data) {
        return data == null || data instanceof List || data instanceof Object[] || data instanceof TableModel || data instanceof Table;
    }

    public static double toDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o != null && !o.equals("")) {
            try {
                return Double.parseDouble(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    public void setZeroAlignment(boolean zero) {
        if (zero != this.zeroAligned) {
            this.zeroAligned = zero;
            this.dataMin = Double.NaN;
            this.dataMax = Double.NaN;
        }
    }

    @Override
    public double getDataMax() {
        this.calculateMinMax();
        return this.dataMax;
    }

    @Override
    public double getDataMin() {
        this.calculateMinMax();
        return this.dataMin;
    }

    @Override
    public double getDataMaxColumn(int col) {
        this.calculateMinMax();
        return col < 0 || col >= this.dataMaxColumn.length ? 0.0 : this.dataMaxColumn[col];
    }

    @Override
    public double getDataMinColumn(int col) {
        this.calculateMinMax();
        return col < 0 || col >= this.dataMinColumn.length ? 0.0 : this.dataMinColumn[col];
    }

    @Override
    public double getDataMaxRow(int row) {
        this.calculateMinMax();
        return row < 0 || row >= this.dataMaxRow.length ? 0.0 : this.dataMaxRow[row];
    }

    @Override
    public double getDataMinRow(int row) {
        this.calculateMinMax();
        return row < 0 || row >= this.dataMinRow.length ? 0.0 : this.dataMinRow[row];
    }

    @Override
    public double getValue(int row, int col) {
        return ChartDataAdapter.toDouble(this.getObjectValue(row, col));
    }

    @Override
    public String getStringValue(int row, int col) {
        Object o = this.getObjectValue(row, col);
        return o == null ? "" : o.toString();
    }

    @Override
    public String getRowLabel(int row) {
        if (this.useRowLabel && this.rowLabelsColumn >= 0 && this.rowLabelsColumn < this.getColumnCount() && row >= 0 && row < this.getRowCount()) {
            return this.getStringValue(row, this.rowLabelsColumn);
        }
        return "ROW " + (row + 1);
    }

    @Override
    public String getColumnLabel(int col) {
        return "COL " + (col + 1);
    }

    @Override
    public boolean isColumnDateTime(int col) {
        return this.checkCol(col, 3);
    }

    @Override
    public boolean isColumnString(int col) {
        return this.checkCol(col, 2);
    }

    @Override
    public boolean isColumnNumeric(int col) {
        return this.checkCol(col, 1);
    }

    @Override
    public boolean isColumnNumeric(int row, int col) {
        return this.checkCol(col, 1);
    }

    @Override
    public void setRowLabelsColumn(int col) {
        if (col >= 0 && col < this.getColumnCount()) {
            this.rowLabelsColumn = col;
        }
    }

    @Override
    public int getRowLabelsColumn() {
        return this.rowLabelsColumn;
    }

    @Override
    public void setUseRowLabels(boolean use) {
        this.useRowLabel = use;
    }

    @Override
    public boolean getUseRowLabels() {
        return this.useRowLabel;
    }

    boolean checkCol(int col, int type) {
        return false;
    }

    private void calculateMinMax() {
        if (!Double.isNaN(this.dataMax)) {
            return;
        }
        double edge = Double.MAX_VALUE;
        double minV = ChartDataAdapter.toDouble(this.minValue);
        double maxV = ChartDataAdapter.toDouble(this.maxValue);
        boolean bMinV = !Double.isNaN(minV);
        boolean bMaxV = !Double.isNaN(maxV);
        minV = bMinV ? minV : edge;
        this.dataMin = minV;
        maxV = bMaxV ? maxV : -edge;
        this.dataMax = maxV;
        int iRows = this.getRowCount();
        int iCols = this.getColumnCount();
        this.dataMaxColumn = new double[iCols];
        this.dataMinColumn = new double[iCols];
        this.dataMaxRow = new double[iRows];
        this.dataMinRow = new double[iRows];
        for (int r = 0; r < iRows; ++r) {
            this.dataMaxRow[r] = maxV;
            this.dataMinRow[r] = minV;
        }
        for (int j = 0; j < iCols; ++j) {
            this.dataMaxColumn[j] = maxV;
            this.dataMinColumn[j] = minV;
            if (bMinV && bMinV || j == this.rowLabelsColumn) continue;
            for (int i = 0; i < iRows; ++i) {
                double val = this.getValue(i, j);
                if (Double.isNaN(val)) continue;
                if (!bMaxV) {
                    if (val > this.dataMax) {
                        this.dataMax = val;
                    }
                    if (val > this.dataMaxColumn[j]) {
                        this.dataMaxColumn[j] = val;
                    }
                    if (val > this.dataMaxRow[i]) {
                        this.dataMaxRow[i] = val;
                    }
                }
                if (bMinV) continue;
                if (val < this.dataMin) {
                    this.dataMin = val;
                }
                if (val < this.dataMinColumn[j]) {
                    this.dataMinColumn[j] = val;
                }
                if (!(val < this.dataMinRow[i])) continue;
                this.dataMinRow[i] = val;
            }
        }
        if (this.dataMin == edge && this.dataMax == -edge) {
            this.dataMax = 0.0;
            this.dataMin = 0.0;
        }
        if (this.zeroAligned) {
            int i;
            if (this.dataMin < 0.0 && this.dataMax < 0.0) {
                this.dataMax = 0.0;
            } else if (this.dataMin > 0.0 && this.dataMax > 0.0) {
                this.dataMin = 0.0;
            }
            for (i = 0; i < this.dataMinColumn.length; ++i) {
                if (this.dataMinColumn[i] < 0.0 && this.dataMaxColumn[i] < 0.0) {
                    this.dataMaxColumn[i] = 0.0;
                    continue;
                }
                if (!(this.dataMinColumn[i] > 0.0) || !(this.dataMaxColumn[i] > 0.0)) continue;
                this.dataMinColumn[i] = 0.0;
            }
            for (i = 0; i < this.dataMinRow.length; ++i) {
                if (this.dataMinRow[i] < 0.0 && this.dataMaxRow[i] < 0.0) {
                    this.dataMaxRow[i] = 0.0;
                    continue;
                }
                if (!(this.dataMinRow[i] > 0.0) || !(this.dataMaxRow[i] > 0.0)) continue;
                this.dataMinRow[i] = 0.0;
            }
        }
    }
}

