/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.util;

import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.FontMetrics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.ui.Ui;

public class Platform {
    private Platform() {
    }

    public static Rectangle getStringSizePixels(String str, Font font) {
        FontMetrics fm = Ui.getToolkit().getFontMetrics(font);
        int width = fm.stringWidth(str);
        int height = fm.getHeight();
        return new Rectangle(0, 0, width, height);
    }

    public static Dimension getSize(String str, Font font) {
        if (font == null) {
            font = DefaultConstants.D_TEXT_FONT;
        }
        int i0 = 0;
        int dimHeight = 0;
        int dimWidth = 0;
        int iLen = str.length();
        for (int i = 0; i < iLen; ++i) {
            if (str.charAt(i) >= ' ' && i != iLen - 1) continue;
            String substr = str.substring(i0, i);
            Rectangle r = Platform.getStringSizePixels(substr, font);
            dimHeight += r.getHeight();
            i0 = r.getWidth();
            if (dimWidth < i0) {
                dimWidth = i0;
            }
            i0 = ++i + 1;
        }
        return Dimension.valueOf(dimWidth, dimHeight);
    }
}

