/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.util;

import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;

public class MiscFunctions {
    public static Color darkenColor(Color color, double percent) {
        return MiscFunctions.shift(color, percent * 0.2, 0);
    }

    public static Color lightenColor(Color color, double percent) {
        return MiscFunctions.shift(color, 0.35 * percent * (2.5 - percent), 255);
    }

    public static Color shift(Color c, double p, int z) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return Color.valueOf(0xFF & r + (int)((double)(z - r) * p), 0xFF & g + (int)((double)(z - g) * p), 0xFF & b + (int)((double)(z - b) * p), c.getAlpha());
    }

    public static Color sideColor(Color c, int side, int style) {
        if (side < 0) {
            return side == -1 ? c : null;
        }
        if ((side = MiscFunctions.inRange(style, side * 4, 15) - 5) == 0 || style == 0 || style == -1) {
            return c;
        }
        if (side < 0) {
            return MiscFunctions.shift(c, (double)(-side) * 0.17, 255);
        }
        return MiscFunctions.shift(c, (double)side * 0.08, 0);
    }

    public static int distance(Color c1, Color c2) {
        int r = c1.getRed() - c2.getRed();
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        return (int)Math.floor(Math.sqrt(r * r + g * g + b * b));
    }

    public static Color altitude(Color c1, Color c2, double percent) {
        if (c1 == null || c2 == null) {
            return null;
        }
        int r = c1.getRed();
        int g = c1.getGreen();
        int b = c1.getBlue();
        r += (int)(percent * (double)(c2.getRed() - r));
        g += (int)(percent * (double)(c2.getGreen() - g));
        b += (int)(percent * (double)(c2.getBlue() - b));
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        return Color.valueOf(r, g, b, c1.getAlpha());
    }

    public static Color average(Color c1, Color c2) {
        return c1 == null || c2 == null ? null : Color.valueOf((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2, c1.getAlpha());
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 instanceof Font && o2 instanceof Font) {
            return ((Font)o1).isBold() == ((Font)o2).isBold() && ((Font)o1).isItalic() == ((Font)o2).isItalic() && ((Font)o1).getSize() == ((Font)o2).getSize() && ((Font)o1).getName().toLowerCase().equals(((Font)o2).getName().toLowerCase());
        }
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static Object[] copy(Object[] source) {
        if (source == null) {
            return source;
        }
        int i = source.length;
        Object[] c = new Object[i];
        while (i-- > 0) {
            c[i] = source[i];
        }
        return c;
    }

    public static boolean isSet(int value, int mask) {
        return (value & mask) != 0;
    }

    public static int inRange(int value, int shift, int max) {
        return max < 7 ? (value >> shift & 7) % (max + 1) : value >> shift & max;
    }

    public static int add(int value, int max, int shift) {
        return (value & max) << shift;
    }

    public static int add(boolean add, int mask) {
        return add ? mask : 0;
    }

    public static boolean isSet(long value, long mask) {
        return (value & mask) != 0L;
    }

    public static int inRange(long value, int shift, int max) {
        return (int)(max < 7 ? (value >> shift & 7L) % (long)(max + 1) : value >> shift & (long)max);
    }

    public static long add(long value, long max, int shift) {
        return (value & max) << shift;
    }
}

