/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.util;

public class Matrix3D {
    public float xo = 0.0f;
    public float yo = 0.0f;
    public float zo = 0.0f;
    float scale_f = 1.0f;
    float xx = 1.0f;
    float yy = 1.0f;
    float zz = 1.0f;
    float xy = 0.0f;
    float xz = 0.0f;
    float yx = 0.0f;
    float yz = 0.0f;
    float zx = 0.0f;
    float zy = 0.0f;

    public void scale(float f) {
        this.xx *= f;
        this.xy *= f;
        this.xz *= f;
        this.xo *= f;
        this.yx *= f;
        this.yy *= f;
        this.yz *= f;
        this.yo *= f;
        this.zx *= f;
        this.zy *= f;
        this.zz *= f;
        this.zo *= f;
        this.scale_f *= f;
    }

    public void scale(float xf, float yf, float zf) {
        this.xx *= xf;
        this.xy *= xf;
        this.xz *= xf;
        this.xo *= xf;
        this.yx *= yf;
        this.yy *= yf;
        this.yz *= yf;
        this.yo *= yf;
        this.zx *= zf;
        this.zy *= zf;
        this.zz *= zf;
        this.zo *= zf;
        this.scale_f *= xf;
    }

    public void translate(float x, float y, float z) {
        this.xo += x;
        this.yo += y;
        this.zo += z;
    }

    public void yrot(double theta) {
        double ct = this.cos(theta);
        double st = this.sin(theta);
        float newXO = (float)((double)this.xo * ct + (double)this.zo * st);
        float newXX = (float)((double)this.xx * ct + (double)this.zx * st);
        float newXY = (float)((double)this.xy * ct + (double)this.zy * st);
        float newXZ = (float)((double)this.xz * ct + (double)this.zz * st);
        float newZO = (float)((double)this.zo * ct - (double)this.xo * st);
        float newZX = (float)((double)this.zx * ct - (double)this.xx * st);
        float newZY = (float)((double)this.zy * ct - (double)this.xy * st);
        float newZZ = (float)((double)this.zz * ct - (double)this.xz * st);
        this.setXValues(newXO, newXX, newXY, newXZ);
        this.setZValues(newZO, newZX, newZY, newZZ);
    }

    public void xrot(double theta) {
        double ct = this.cos(theta);
        double st = this.sin(theta);
        float newYO = (float)((double)this.yo * ct + (double)this.zo * st);
        float newYX = (float)((double)this.yx * ct + (double)this.zx * st);
        float newYY = (float)((double)this.yy * ct + (double)this.zy * st);
        float newYZ = (float)((double)this.yz * ct + (double)this.zz * st);
        float newZO = (float)((double)this.zo * ct - (double)this.yo * st);
        float newZX = (float)((double)this.zx * ct - (double)this.yx * st);
        float newZY = (float)((double)this.zy * ct - (double)this.yy * st);
        float newZZ = (float)((double)this.zz * ct - (double)this.yz * st);
        this.setYValues(newYO, newYX, newYY, newYZ);
        this.setZValues(newZO, newZX, newZY, newZZ);
    }

    public void zrot(double theta) {
        double ct = this.cos(theta);
        double st = this.sin(theta);
        float newYO = (float)((double)this.yo * ct + (double)this.xo * st);
        float newYX = (float)((double)this.yx * ct + (double)this.xx * st);
        float newYY = (float)((double)this.yy * ct + (double)this.xy * st);
        float newYZ = (float)((double)this.yz * ct + (double)this.xz * st);
        float newXX = (float)((double)this.xx * ct - (double)this.yx * st);
        float newXY = (float)((double)this.xy * ct - (double)this.yy * st);
        float newXZ = (float)((double)this.xz * ct - (double)this.yz * st);
        float newXO = (float)((double)this.xo * ct - (double)this.yo * st);
        this.setXValues(newXO, newXX, newXY, newXZ);
        this.setYValues(newYO, newYX, newYY, newYZ);
    }

    public void unit() {
        this.setXValues(0.0f, 1.0f, 0.0f, 0.0f);
        this.setYValues(0.0f, 0.0f, 1.0f, 0.0f);
        this.setZValues(0.0f, 0.0f, 0.0f, 1.0f);
        this.scale_f = 1.0f;
    }

    public void transform(float[] v, int i) {
        i *= 3;
        while ((i -= 3) >= 0) {
            float x = v[i];
            float y = v[i + 1];
            float z = v[i + 2];
            v[i] = x * this.xx + y * this.xy + z * this.xz + this.xo;
            v[i + 1] = x * this.yx + y * this.yy + z * this.yz + this.yo;
            v[i + 2] = x * this.zx + y * this.zy + z * this.zz + this.zo;
        }
    }

    public float transform(float r) {
        return r * this.scale_f;
    }

    private double sin(double theta) {
        return Math.sin(theta * (Math.PI / 180));
    }

    private double cos(double theta) {
        return Math.cos(theta * (Math.PI / 180));
    }

    private void setXValues(float nxo, float nxx, float nxy, float nxz) {
        this.xo = nxo;
        this.xx = nxx;
        this.xy = nxy;
        this.xz = nxz;
    }

    private void setZValues(float nzo, float nzx, float nzy, float nzz) {
        this.zo = nzo;
        this.zx = nzx;
        this.zy = nzy;
        this.zz = nzz;
    }

    private void setYValues(float nyo, float nyx, float nyy, float nyz) {
        this.yo = nyo;
        this.yx = nyx;
        this.yy = nyy;
        this.yz = nyz;
    }
}

