/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.resources.IRenderLabel;
import oracle.bpm.lang.Time;

public class LabelFormatter {
    public static String replaceKeywords(String str) {
        String result = str;
        int startPos = 0;
        while (startPos < str.length() - 1 && (startPos = str.indexOf(60, startPos) + 1) > 0) {
            String format;
            String replaceStr;
            String keyword;
            int endPos = str.indexOf(58, startPos);
            int endPos1 = str.indexOf(62, startPos);
            if (endPos > startPos && endPos1 > endPos) {
                keyword = str.substring(startPos, endPos);
                startPos = endPos + 1;
                replaceStr = '<' + keyword;
                endPos = str.indexOf(62, startPos);
                if (endPos < startPos) continue;
                format = str.substring(startPos, endPos).trim();
                replaceStr = replaceStr + ':' + format + '>';
                startPos = endPos;
            } else {
                if (endPos1 < startPos) continue;
                keyword = str.substring(startPos, endPos1);
                replaceStr = '<' + keyword + '>';
                startPos = endPos1;
                format = "";
            }
            if (keyword.length() == 0) continue;
            keyword = keyword.trim();
            Object obj = ChartCore.Environment.get(keyword);
            ChartCore.Environment.put("RENDER_KEYWORD", keyword);
            ChartCore.Environment.put("RENDER_FORMAT", format);
            if (obj == null) continue;
            result = LabelFormatter.replace(result, replaceStr, LabelFormatter.format(obj, format));
        }
        return result;
    }

    public static String replace(String source, String old, String str) {
        int i = source.indexOf(old);
        if (i < 0) {
            return source;
        }
        StringBuffer b = new StringBuffer(source);
        b.replace(i, i + old.length(), str);
        return new String(b);
    }

    public static String[] split(String source, String separators) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(source, separators);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.length() <= 0) continue;
            list.add(s);
        }
        return (String[])list.toArray();
    }

    public static String number(double value, String format) {
        return new DecimalFormat(format == null ? "0.00" : format).format(value);
    }

    public static String number(float value, String format) {
        return new DecimalFormat(format == null ? "0.00" : format).format(value);
    }

    public static String date(Date value, String format) {
        return new SimpleDateFormat(format == null ? "dd/MM/yyyy" : format).format(value);
    }

    public static String format(Object value, String format) {
        if (value == null) {
            return "";
        }
        if (value instanceof IRenderLabel) {
            return ((IRenderLabel)value).toString(ChartCore.Environment);
        }
        if (format.length() > 0) {
            boolean abs;
            boolean bl = abs = format.charAt(0) == '+';
            if (abs) {
                format = format.substring(1);
            }
            if (value instanceof Float) {
                return LabelFormatter.number(abs ? Math.abs(((Float)value).floatValue()) : ((Float)value).floatValue(), format);
            }
            if (value instanceof Double) {
                String s = LabelFormatter.number(abs ? Math.abs((Double)value) : (Double)value, format);
                if ("INTERVAL".equals(format)) {
                    s = Time.valueOf(value).formatTimeOnly();
                }
                return s;
            }
            if (value instanceof Number) {
                return LabelFormatter.number(abs ? Math.abs(((Number)value).doubleValue()) : ((Number)value).doubleValue(), format);
            }
            if (value instanceof Date) {
                return LabelFormatter.date((Date)value, format);
            }
        }
        return value.toString();
    }
}

