/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.primitives;

public class Vector3D {
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;

    public Vector3D() {
    }

    public Vector3D(Vector3D vector) {
        this.x = vector.x;
        this.y = vector.y;
        this.z = vector.z;
    }

    public Vector3D(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
    }

    public static Vector3D add(Vector3D a, Vector3D b) {
        return new Vector3D(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static Vector3D sub(Vector3D a, Vector3D b) {
        return new Vector3D(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static Vector3D scale(float f, Vector3D a) {
        return new Vector3D(f * a.x, f * a.y, f * a.z);
    }

    public void normalize() {
        float dist = this.length();
        if (dist == 0.0f) {
            return;
        }
        dist = 1.0f / dist;
        this.x *= dist;
        this.y *= dist;
        this.z *= dist;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }
}

