/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.primitives;

import oracle.bpm.chart.core.primitives.DataPoint;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Polygon;

public class Polyline
extends PrimitiveShape {
    public DataPoint[] points;

    public Polyline(DataPoint[] points, Color clr) {
        this(points, null, 1, clr);
        this.hitMe = false;
    }

    public Polyline(DataPoint[] points, LineStyle style, int w, Color color) {
        super(style);
        this.points = points;
        this.drawThickness = w;
        this.drawColor = color;
        this.hitMe = true;
        if (points == null) {
            return;
        }
        int iLen = points.length - 1;
        if (iLen < 0) {
            return;
        }
        if (w == 0) {
            w = 1;
        }
        int lastWidth = w;
        if (iLen > 0) {
            lastWidth = (points[1].point.getX() - points[0].point.getX()) / 2;
        }
        if (lastWidth > 4) {
            lastWidth = 4;
        }
        if (lastWidth < 2) {
            lastWidth = 2;
        }
        for (int i = 0; i <= iLen; ++i) {
            DataPoint p1 = points[i];
            DataPoint p2 = points[i == iLen ? i : i + 1];
            int[] xp = new int[5];
            int[] yp = new int[5];
            int x = p1.point.getX();
            if (i == iLen) {
                x -= lastWidth / 2;
            }
            xp[4] = xp[3] = x;
            xp[0] = xp[3];
            yp[0] = yp[4] = p1.point.getY() - w / 2;
            x = p2.point.getX();
            if (i == iLen) {
                x += lastWidth;
            }
            xp[1] = xp[2] = x;
            yp[1] = p2.point.getY() - w / 2;
            yp[2] = yp[1] + w;
            yp[3] = yp[0] + w;
            p1.area = new Polygon[]{null, new Polygon(xp, yp, 5)};
        }
    }

    @Override
    public Primitive[] getPrimitives() {
        return this.hitMe ? this.points : null;
    }

    @Override
    public int type() {
        return 17;
    }
}

