/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.primitives;

import oracle.bpm.chart.core.primitives.Face;
import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.core.primitives.Vector3D;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Polygon;

public class IFGOFF
extends PrimitiveShape {
    public transient Color[] corners;
    public Face[] face;
    public transient int lines = 1;
    public int nverts = 0;
    public int nfaces = 0;
    public int nedges = 0;
    public transient int quality = -1;
    public float[] vert;

    public IFGOFF() {
        this.hitMe = true;
    }

    public IFGOFF(float[] p) {
        this.vert = p;
        this.nverts = 7;
    }

    public IFGOFF(Vector3D[][] pp, Color fillClr, Color drawClr, Color[] corners, int quality, int lines, int i, int j) {
        this.nedges = 4;
        this.nverts = 4;
        this.nfaces = 1;
        this.vert = new float[12];
        this.face = new Face[]{new Face(new int[]{0, 1, 2, 3}, -1)};
        this.vert[0] = pp[i][j].x;
        this.vert[1] = pp[i][j].y;
        this.vert[2] = pp[i][j].z;
        this.vert[3] = pp[i][j - 1].x;
        this.vert[4] = pp[i][j - 1].y;
        this.vert[5] = pp[i][j - 1].z;
        this.vert[6] = pp[i + 1][j - 1].x;
        this.vert[7] = pp[i + 1][j - 1].y;
        this.vert[8] = pp[i + 1][j - 1].z;
        this.vert[9] = pp[i + 1][j].x;
        this.vert[10] = pp[i + 1][j].y;
        this.vert[11] = pp[i + 1][j].z;
        this.hitMe = true;
        this.row = i;
        this.column = j - 1;
        this.fillColor = fillClr;
        this.drawColor = drawClr;
        this.corners = corners;
        this.quality = quality;
        this.lines = lines;
    }

    public static IFGOFF rectangle(Vector3D p1, Vector3D p2, Vector3D p3, Vector3D p4, Color color) {
        IFGOFF result = new IFGOFF();
        result.fillColor = result.drawColor = color;
        result.nverts = 4;
        result.nfaces = 1;
        result.nedges = 4;
        result.vert = new float[]{p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, p3.x, p3.y, p3.z, p4.x, p4.y, p4.z};
        result.face = new Face[]{new Face(new int[]{0, 1, 2, 3}, -1)};
        result.hitMe = false;
        return result;
    }

    @Override
    public boolean hitTest(Point p) {
        if (!this.hitMe) {
            return false;
        }
        this.hit1 &= 0xF;
        if (this.quality >= 0 && this.area instanceof Polygon[]) {
            int[] xx = ((Polygon[])this.area)[0].xpoints;
            int[] yy = ((Polygon[])this.area)[0].ypoints;
            for (int hit = 0; hit <= 3; ++hit) {
                int x = xx[hit];
                int y = yy[hit];
                if (x + 4 < p.getX() || p.getX() + 4 < x || y + 4 < p.getY() || p.getY() + 4 < y) continue;
                this.hit1 |= hit + 1 << 4;
                return true;
            }
            if (this.is1()) {
                return false;
            }
        }
        return super.hitTest(p);
    }

    @Override
    public int fullHit() {
        int i = super.fullHit();
        if (i == 1) {
            i = 2;
        } else if (i == 2) {
            i = 1;
        }
        return i;
    }

    @Override
    public int type() {
        return 9;
    }
}

