/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.primitives;

import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.geom.Point;

public class Ellipse
extends PrimitiveShape {
    public Point p1;
    public Point p2;

    public Ellipse() {
        this.p1 = new Point(0, 0);
        this.p2 = new Point(0, 0);
    }

    public Ellipse(Point p1, Point p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public Ellipse(Point p1, int radius) {
        this.p1 = new Point(p1.getX() - radius, p1.getY() - radius);
        this.p2 = new Point(radius * 2, radius * 2);
    }

    public Ellipse(Point p1, Point p2, LineStyle style) {
        super(style);
        this.p1 = p1;
        this.p2 = p2;
    }

    public Ellipse(Point p1, int radius, LineStyle style) {
        super(style);
        this.p1 = new Point(p1.getX() - radius, p1.getY() - radius);
        this.p2 = new Point(radius * 2, radius * 2);
    }

    @Override
    public boolean hitTest(Point point) {
        return new oracle.bpm.geom.Ellipse(this.p1.getX(), this.p1.getY(), this.p2.getX(), this.p2.getY()).contains(point.getX(), point.getY());
    }

    @Override
    public int type() {
        return 6;
    }
}

