/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.primitives;

import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Polygon;

public class DataPoint
extends Primitive {
    public transient int hitTestRadius = 0;
    public transient Point point;

    public DataPoint() {
        this(0, 0);
    }

    public DataPoint(Point p) {
        this.point = p;
    }

    public DataPoint(int x, int y) {
        this(new Point(x, y));
    }

    public DataPoint(Point p, boolean hitOne) {
        this.point = p;
        this.hit1 = hitOne ? 8 : 0;
    }

    @Override
    public boolean hitTest(Point p) {
        if (!this.hitMe) {
            return false;
        }
        this.hit1 &= 0xF;
        int i = 4;
        if (this.point.getX() + i >= p.getX() && p.getX() + i >= this.point.getX() && this.point.getY() + i >= p.getY() && p.getY() + i >= this.point.getY()) {
            if (!this.is1()) {
                this.hit1 |= 0x10;
            }
            return true;
        }
        int n = i = this.area instanceof Polygon[] ? ((Polygon[])this.area).length : 0;
        if (this.is1() && i > 0) {
            i = 1;
        }
        while (i-- > 0) {
            if (((Polygon[])this.area)[i] == null || !((Polygon[])this.area)[i].contains(p)) continue;
            if (i == 0 && !this.is1()) {
                this.hit1 |= 0x10;
            }
            return true;
        }
        i = this.hitTestRadius;
        if (i <= 4) {
            return false;
        }
        return this.point.getX() + i >= p.getX() && p.getX() + i >= this.point.getX() && this.point.getY() + i >= p.getY() && p.getY() + i >= this.point.getY();
    }

    @Override
    public int type() {
        return 4;
    }
}

