/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.primitives;

import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

public class Box
extends PrimitiveShape {
    public Color[] corners;
    public Color gradientFillColor;
    public int lines = 1;
    public int orientation = 1;
    public int quality = -1;
    public Rectangle rect;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public Box(Rectangle r) {
        this.rect = r;
    }

    public Box(Rectangle rect, LineStyle style) {
        super(style);
        this.rect = rect;
    }

    public Box(Rectangle rect, Color fill, Color draw) {
        this(rect);
        this.fillColor = fill;
        this.drawColor = draw;
    }

    public Box(Point topLeft, int width, int height) {
        this(topLeft, width, height, new LineStyle());
    }

    public Box(Point topLeft, int width, int height, LineStyle style) {
        this(new Rectangle(topLeft.getX(), topLeft.getY(), width, height), style);
    }

    public Box(int row, int col, Color fill, Color draw, int quality, int lines) {
        this.row = row;
        this.column = col;
        this.fillColor = fill;
        this.drawColor = draw;
        this.quality = quality;
        this.lines = lines;
        this.hitMe = true;
    }

    @Override
    public boolean hitTest(Point p) {
        if (!this.hitMe) {
            return false;
        }
        this.hit1 &= 0xF;
        if (this.quality >= 0) {
            int i = 4;
            int j = this.rect.getWidth() / 3;
            if (i > j) {
                i = j;
            }
            if (i > (j = this.rect.getHeight() / 3)) {
                i = j;
            }
            int x = this.rect.getX();
            int y = this.rect.getY();
            for (int hit = 1; hit <= 4; ++hit) {
                x = this.rect.getX();
                if ((hit & 1) == 0) {
                    x += this.rect.getWidth();
                }
                if (hit == 3) {
                    y += this.rect.getHeight();
                }
                if (x + i < p.getX() || p.getX() + i < x || y + i < p.getY() || p.getY() + i < y) continue;
                this.hit1 |= hit << 4;
                return true;
            }
            if (this.is1()) {
                return false;
            }
        }
        return this.hitMe ? this.rect.contains(p) : false;
    }

    @Override
    public int type() {
        return 1;
    }
}

