/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.Layer;
import oracle.bpm.chart.core.layers.LinearAxis;
import oracle.bpm.chart.core.layers.SetLabelAxis;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.AxisAppearance;
import oracle.bpm.chart.resources.appearance.AxisLabelAppearance;
import oracle.bpm.chart.resources.appearance.BarChartAppearance;
import oracle.bpm.chart.resources.appearance.BubbleChartAppearance;
import oracle.bpm.chart.resources.appearance.CandleChartAppearance;
import oracle.bpm.chart.resources.appearance.ChartTypeAppearance;
import oracle.bpm.chart.resources.appearance.ColumnChartAppearance;
import oracle.bpm.chart.resources.appearance.ScatterChartAppearance;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.geom.Point;

public class TwoDGridLayer
extends Layer {
    transient ChartType chartType = ChartType.COLUMN_CHART;
    transient Axis x_axis;
    transient Axis y_axis;

    public TwoDGridLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    public Axis getX() {
        return this.x_axis;
    }

    public void setX(Axis value) {
        this.x_axis = value;
    }

    public Axis getY() {
        return this.y_axis;
    }

    public void setY(Axis value) {
        this.y_axis = value;
    }

    public void setChartType(ChartType type) {
        this.chartType = type;
        switch (this.chartType) {
            case STACK_BAR_CHART: 
            case BAR_CHART: {
                this.x_axis = new LinearAxis(this.component, this.core, 0, 0);
                this.y_axis = new SetLabelAxis(this.component, this.core, 1, 4);
                if (!this.chartType.equals(ChartType.STACK_BAR_CHART)) break;
                this.y_axis.stack = true;
                this.y_axis.itemLabelFormat = "";
                if (this.core.stackStyle != 1) break;
                this.x_axis.itemLabelFormat = "<DATA_VALUE:+0>%";
                break;
            }
            case STACK_COLUMN_CHART: 
            case COLUMN_CHART: {
                this.x_axis = new SetLabelAxis(this.component, this.core, 0, 4);
                this.y_axis = new LinearAxis(this.component, this.core, 1, 0);
                if (!this.chartType.equals(ChartType.STACK_COLUMN_CHART)) break;
                this.x_axis.stack = true;
                this.x_axis.itemLabelFormat = "";
                if (this.core.stackStyle != 1) break;
                this.y_axis.itemLabelFormat = "<DATA_VALUE:+0>%";
                break;
            }
            case HEAT_MAP_CHART: {
                this.x_axis = new LinearAxis(this.component, this.core, 0, 2);
                this.y_axis = new LinearAxis(this.component, this.core, 1, 1);
                break;
            }
            case BUBBLE_CHART: 
            case SCATTER_CHART: {
                this.x_axis = new LinearAxis(this.component, this.core, 0, 0);
                this.y_axis = new LinearAxis(this.component, this.core, 1, 0);
                break;
            }
            case CANDLE_CHART: {
                this.x_axis = new LinearAxis(this.component, this.core, 0, 3);
                this.y_axis = new LinearAxis(this.component, this.core, 1, 0);
                break;
            }
            default: {
                this.x_axis = new LinearAxis(this.component, this.core, 0, 2);
                this.y_axis = new LinearAxis(this.component, this.core, 1, 0);
            }
        }
        this.x_axis.addStyle(32768);
        this.y_axis.addStyle(65536);
        this.resetAxisLabelFormat();
    }

    public void fillSceneGraph2(SceneGraph scene) {
        if (!this.isVisible() || this.x_axis == null || this.y_axis == null) {
            return;
        }
        this.x_axis.drawLine(scene);
        this.y_axis.drawLine(scene);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        if (!this.isVisible() || this.x_axis == null || this.y_axis == null) {
            return;
        }
        this.x_axis.dataMin = this.y_axis.dataMin = this.core.dataMin;
        this.x_axis.dataMax = this.y_axis.dataMax = this.core.dataMax;
        if (this.core.stackStyle == 1) {
            this.y_axis.dataMin = this.core.dataMax > 0.0 ? 0.0 : -100.0;
            this.x_axis.dataMin = this.y_axis.dataMin;
            this.y_axis.dataMax = this.core.dataMax > 0.0 ? 100.0 : 0.0;
            this.x_axis.dataMax = this.y_axis.dataMax;
        }
        if (this.chartType.equals(ChartType.BUBBLE_CHART) || this.chartType.equals(ChartType.SCATTER_CHART)) {
            ChartTypeAppearance b;
            int xCol = 1;
            int yCol = 2;
            if (this.chartType.equals(ChartType.BUBBLE_CHART)) {
                b = (BubbleChartAppearance)this.component.getChartAppearance(17);
                xCol = ((BubbleChartAppearance)b).getColumnX();
                yCol = ((BubbleChartAppearance)b).getColumnY();
            } else {
                b = (ScatterChartAppearance)this.component.getChartAppearance(18);
                xCol = ((ScatterChartAppearance)b).getColumnX();
                yCol = ((ScatterChartAppearance)b).getColumnY();
            }
            this.x_axis.dataMin = this.data.getDataMinColumn(xCol);
            this.x_axis.dataMax = this.data.getDataMaxColumn(xCol);
            this.y_axis.dataMin = this.data.getDataMinColumn(yCol);
            this.y_axis.dataMax = this.data.getDataMaxColumn(yCol);
            double range = Math.abs(this.x_axis.dataMax - this.x_axis.dataMin);
            if (range == 0.0) {
                this.x_axis.dataMax = this.x_axis.dataMin + 0.1;
            }
            double fivePercentBuffer = range * 5.0 / 100.0;
            this.x_axis.dataMax += fivePercentBuffer;
            this.x_axis.dataMin -= fivePercentBuffer;
            range = Math.abs(this.y_axis.dataMax - this.y_axis.dataMin);
            if (range == 0.0) {
                this.y_axis.dataMax = this.y_axis.dataMin + 0.1;
            }
            fivePercentBuffer = range * 5.0 / 100.0;
            this.y_axis.dataMax += fivePercentBuffer;
            this.y_axis.dataMin -= fivePercentBuffer;
        }
        if (this.chartType.equals(ChartType.CANDLE_CHART)) {
            this.x_axis.dateSkipN = ((CandleChartAppearance)this.component.getChartAppearance(25)).getSkipN();
            this.x_axis.dataMin = 0.0;
            this.x_axis.dataMax = this.data.getRowCount();
            this.y_axis.dataMin = Math.min(Math.min(this.data.getDataMinColumn(1), this.data.getDataMinColumn(2)), Math.min(this.data.getDataMinColumn(3), this.data.getDataMinColumn(4)));
            this.y_axis.dataMax = Math.max(Math.max(this.data.getDataMaxColumn(1), this.data.getDataMaxColumn(2)), Math.max(this.data.getDataMaxColumn(3), this.data.getDataMaxColumn(4)));
        }
        this.x_axis.setData(this.data);
        this.y_axis.setData(this.data);
        int intraSpacing = 0;
        int interSpacing = 0;
        if (this.chartType.equals(ChartType.BAR_CHART) || this.chartType.equals(ChartType.STACK_BAR_CHART)) {
            BarChartAppearance barApp = (BarChartAppearance)this.component.getChartAppearance(12);
            intraSpacing = barApp.getBarSpacing();
            interSpacing = barApp.getSeriesSpacing();
        } else if (this.chartType.equals(ChartType.COLUMN_CHART) || this.chartType.equals(ChartType.STACK_COLUMN_CHART)) {
            ColumnChartAppearance colApp = (ColumnChartAppearance)this.component.getChartAppearance(13);
            intraSpacing = colApp.getColumnSpacing();
            interSpacing = colApp.getSeriesSpacing();
        }
        if (this.x_axis instanceof SetLabelAxis) {
            ((SetLabelAxis)this.x_axis).interItemSpacing = intraSpacing;
            ((SetLabelAxis)this.x_axis).interSeriesSpacing = interSpacing;
        } else if (this.y_axis instanceof SetLabelAxis) {
            ((SetLabelAxis)this.y_axis).interItemSpacing = intraSpacing;
            ((SetLabelAxis)this.y_axis).interSeriesSpacing = interSpacing;
        }
        this.x_axis.outerBounds = this.outerBounds;
        this.x_axis.innerBounds = this.innerBounds;
        this.x_axis.retrieveAppearanceProperties();
        this.outerBounds = this.x_axis.outerBounds;
        this.innerBounds = this.x_axis.innerBounds;
        this.y_axis.outerBounds = this.outerBounds;
        this.y_axis.innerBounds = this.innerBounds;
        this.y_axis.retrieveAppearanceProperties();
        this.outerBounds = this.y_axis.outerBounds;
        this.innerBounds = this.y_axis.innerBounds;
        this.x_axis.startPoint = new Point(this.innerBounds.getX(), this.innerBounds.getY() + this.innerBounds.getHeight());
        this.x_axis.endPoint = new Point(this.innerBounds.getX() + this.innerBounds.getWidth(), this.innerBounds.getY() + this.innerBounds.getHeight());
        this.y_axis.startPoint = this.x_axis.startPoint;
        this.y_axis.endPoint = new Point(this.innerBounds.getX(), this.innerBounds.getY());
        this.x_axis.axisLineStart = this.x_axis.startPoint;
        this.x_axis.axisLineEnd = this.x_axis.endPoint;
        this.y_axis.axisLineStart = this.y_axis.startPoint;
        this.y_axis.axisLineEnd = this.y_axis.endPoint;
        if (this.x_axis.axisType == 0 && this.x_axis.dataMin < 0.0 && this.x_axis.dataMax >= 0.0) {
            int zeroX = this.x_axis.startPoint.getX() + (int)(this.x_axis.dataMin * (double)(this.x_axis.startPoint.getX() - this.x_axis.endPoint.getX()) / (this.x_axis.dataMax - this.x_axis.dataMin));
            this.y_axis.axisLineStart = new Point(zeroX, this.y_axis.startPoint.getY());
            this.y_axis.axisLineEnd = new Point(zeroX, this.y_axis.endPoint.getY());
        }
        if (this.y_axis.axisType == 0 && this.y_axis.dataMin < 0.0 && this.y_axis.dataMax >= 0.0) {
            int zeroY = this.y_axis.startPoint.getY() + (int)(this.y_axis.dataMin * (double)(this.y_axis.startPoint.getY() - this.y_axis.endPoint.getY()) / (this.y_axis.dataMax - this.y_axis.dataMin));
            this.x_axis.axisLineStart = new Point(this.x_axis.startPoint.getX(), zeroY);
            this.x_axis.axisLineEnd = new Point(this.x_axis.endPoint.getX(), zeroY);
        }
        this.y_axis.fillSceneGraph(scene);
        this.x_axis.fillSceneGraph(scene);
    }

    void resetAxisLabelFormat() {
        AxisAppearance axisApp = (AxisAppearance)this.component.getChartAppearance(9);
        axisApp.setNoUpdate(true);
        AxisLabelAppearance lbl = axisApp.getLabels();
        lbl.setItemFormatString(this.x_axis.itemLabelFormat);
        lbl.setSeriesFormatString(this.x_axis.seriesLabelFormat);
        if (this.chartType.equals(ChartType.CANDLE_CHART)) {
            lbl.setItemFormatString(this.x_axis.itemLabelFormat);
        }
        axisApp.setNoUpdate(false);
        axisApp = (AxisAppearance)this.component.getChartAppearance(10);
        axisApp.setNoUpdate(true);
        lbl = axisApp.getLabels();
        lbl.setItemFormatString(this.y_axis.itemLabelFormat);
        lbl.setSeriesFormatString(this.y_axis.seriesLabelFormat);
        axisApp.setNoUpdate(false);
    }
}

