/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.LabelRenderLocation;
import oracle.bpm.chart.core.primitives.Text;
import oracle.bpm.chart.core.util.LabelFormatter;
import oracle.bpm.chart.core.util.Platform;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

class SetLabelAxis
extends Axis {
    int rowCount;
    int colCount;
    String[] rowLabels;

    SetLabelAxis(IChartComponent component, ChartCore core, int axisNumber, int type) {
        super(component, core, axisNumber, type);
        this.itemLabelFormat = DefaultConstants.D_AXIS_LABEL_FORMAT_ITEM;
        this.seriesLabelFormat = DefaultConstants.D_AXIS_LABEL_FORMAT_SERIES;
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        super.fillSceneGraph(scene);
        if (this.interItemSpacing > this.interSeriesSpacing) {
            this.interSeriesSpacing = this.interItemSpacing;
        }
        boolean horiz = (this.drawingStyle & 0x8000) != 0;
        int totalWidth = horiz ? this.endPoint.getX() - this.startPoint.getX() : this.startPoint.getY() - this.endPoint.getY();
        int colCount = this.colCount;
        if (this.stack) {
            colCount = 1;
            this.interItemSpacing = 0;
        }
        Rectangle r = this.core.getTitleLayer().getInnerBounds();
        int shift = SetLabelAxis.itemPoint(this.rowCount * colCount, colCount, this.interSeriesSpacing, this.interItemSpacing, totalWidth, -3) + SetLabelAxis.itemPoint(this.rowCount * colCount, colCount, this.interSeriesSpacing, this.interItemSpacing, totalWidth, -1) / 2;
        int y0 = horiz ? this.startPoint.getY() : this.endPoint.getY();
        int shift1 = SetLabelAxis.itemPoint(this.rowCount * colCount, colCount, this.interSeriesSpacing, this.interItemSpacing, totalWidth, this.rowCount * colCount);
        int iDelta = this.rowCount != 0 ? (totalWidth - shift1) / this.rowCount : 0;
        int iStart = 0;
        if (this.stack) {
            iStart = iDelta / 2;
        } else if (!horiz) {
            y0 += shift1;
        }
        for (int i = 0; i < this.rowCount; ++i) {
            int item_i = i * colCount;
            int x = this.startPoint.getX();
            int y = y0;
            if (horiz) {
                x += iDelta * i + iDelta - iStart;
            } else {
                y += iDelta * i + iStart;
            }
            this.addLine(scene, x, y, true, horiz);
            if ((this.drawingStyle & 0x40000) > 0) {
                Point p = this.stack ? (horiz ? new Point(x, y0 + this.gap) : new Point(this.startPoint.getX() - this.gap, y)) : (horiz ? new Point(x - iDelta / 2, r.getY() + r.getHeight() - 1) : new Point(r.getX() + 1, y + iDelta / 2));
                scene.add(new Text(p, this.rowLabels[horiz ? i : this.rowCount - i - 1], this.seriesLabelStyle));
            }
            if (this.stack) continue;
            int j = 0;
            while (j < colCount) {
                shift1 = SetLabelAxis.itemPoint(this.rowCount * colCount, colCount, this.interSeriesSpacing, this.interItemSpacing, totalWidth, item_i);
                x = this.startPoint.getX();
                y = y0;
                if (horiz) {
                    x += shift1 + shift;
                } else {
                    y += shift1 + shift;
                }
                this.addLine(scene, x, y, false, horiz);
                if (horiz) {
                    y += this.gap;
                } else {
                    x -= this.gap;
                }
                if ((this.drawingStyle & 0x40000) > 0) {
                    scene.add(new Text(new Point(x, y), this.labels[horiz ? j : colCount - j - 1], this.labelStyle));
                }
                ++j;
                ++item_i;
            }
        }
    }

    @Override
    int getExtent() {
        int i;
        String str;
        int ext1 = this.extent;
        boolean horiz = (this.drawingStyle & 0x8000) != 0;
        int tick = this.gap;
        tick += 6;
        if (ext1 >= 0) {
            tick = ext1;
        }
        if ((this.drawingStyle & 0x40000) == 0) {
            return tick;
        }
        boolean doWidth1 = false;
        boolean doWidth2 = false;
        if (ext1 < 0) {
            if (horiz) {
                doWidth1 = this.labelStyle.getOrientation() != 0;
                doWidth2 = this.seriesLabelStyle.getOrientation() != 0;
            } else {
                doWidth1 = this.labelStyle.getOrientation() == 0;
                doWidth2 = this.seriesLabelStyle.getOrientation() == 0;
            }
        }
        boolean checkVert1 = this.labelStyle.getOrientation() != 0 && horiz;
        boolean checkVert2 = this.seriesLabelStyle.getOrientation() != 0 && !horiz;
        this.colCount = this.stack ? 0 : this.data.getColumnCount();
        this.rowCount = this.data.getRowCount();
        if (this.labels == null || this.labels.length < this.colCount) {
            this.labels = new String[this.colCount];
        }
        if (this.rowLabels == null || this.rowLabels.length < this.rowCount) {
            this.rowLabels = new String[this.rowCount];
        }
        ext1 = 0;
        int ext2 = 0;
        int count = this.stack ? 0 : this.colCount;
        ChartCore.Environment.put("LABEL_RENDER_LOCATION", LabelRenderLocation.AXIS);
        while (count-- > 0) {
            ChartCore.Environment.put("DATA_VALUE", count);
            ChartCore.Environment.put("ITEM_LABEL", this.data.getColumnLabel(count));
            str = this.labels[count] = LabelFormatter.replaceKeywords(this.itemLabelFormat);
            if (checkVert1 && str.length() > 2) {
                checkVert1 = false;
            }
            if (!doWidth1 || (i = Platform.getStringSizePixels(this.labels[count], this.labelStyle.getFont()).getWidth()) <= ext1) continue;
            ext1 = i;
        }
        count = this.rowCount;
        while (count-- > 0) {
            ChartCore.Environment.put("DATA_VALUE", count);
            ChartCore.Environment.put("SERIES_LABEL", this.data.getRowLabel(count));
            str = this.rowLabels[count] = LabelFormatter.replaceKeywords(this.seriesLabelFormat);
            if (checkVert2 && str.length() > 2) {
                checkVert2 = false;
            }
            if (!doWidth2 && !checkVert2 || (i = Platform.getStringSizePixels(this.rowLabels[count], this.seriesLabelStyle.getFont()).getWidth()) <= ext2) continue;
            ext2 = i;
        }
        if (this.extent >= 0) {
            return this.extent;
        }
        if (checkVert1) {
            this.labelStyle.setOrientation(0);
            this.labelStyle.setVerticalAlign(2);
            this.labelStyle.setHorizontalAlign(0);
            doWidth1 = false;
        }
        if (checkVert2) {
            this.seriesLabelStyle.setOrientation(0);
            this.seriesLabelStyle.setHorizontalAlign(2);
            this.seriesLabelStyle.setVerticalAlign(0);
            ext2 += 2;
            doWidth2 = true;
        }
        if (!horiz) {
            ext1 += 2;
        }
        ext1 = tick + (doWidth1 ? ext1 * 9 / 8 : this.labelStyle.getFont().getSize() * 9 / 8);
        ext2 = tick + (doWidth2 ? ext2 * 9 / 8 : this.seriesLabelStyle.getFont().getSize() * 9 / 8);
        if (this.stack) {
            return ext2;
        }
        return ext1 + ext2;
    }
}

