/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.primitives.DataPoint;
import oracle.bpm.chart.core.primitives.PointSet;
import oracle.bpm.chart.core.primitives.Polyline;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.data.IChartDataFilter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.ScatterChartAppearance;
import oracle.bpm.geom.Point;

public class ScatterLayer
extends ChartLayer {
    Hashtable<String, Integer> map = new Hashtable();
    int seriesCount = 1;
    String[] seriesLabels;
    private int firstIcon = 2;
    private int symbolIconCount = 9;
    static final int SMALL_ICON_COUNT = 25;
    static final int MEDIUM_ICON_COUNT = 100;

    public ScatterLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(18);
    }

    @Override
    public String getDataInvalidMessage() {
        return "Scatter Chart should have at least 1 row and 2 numeric columns";
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        String rowGroupName;
        super.fillSceneGraph(scene);
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        if (colCount < 2) {
            return;
        }
        ScatterChartAppearance scatterApp = (ScatterChartAppearance)this.getAppearance();
        int colX = scatterApp.getColumnX();
        int colY = scatterApp.getColumnY();
        int groupCol = scatterApp.getGroupByColumn();
        if (this.data instanceof IChartDataFilter) {
            colX = ((IChartDataFilter)((Object)this.data)).getFilteredColumnNumber(colX);
            colY = ((IChartDataFilter)((Object)this.data)).getFilteredColumnNumber(colY);
            groupCol = ((IChartDataFilter)((Object)this.data)).getFilteredColumnNumber(groupCol);
        }
        if (colX < 0 || colX >= colCount) {
            colX = 0;
        }
        if (colY < 0 || colY >= colCount) {
            colY = 1;
        }
        if (groupCol < 0 || groupCol >= colCount) {
            groupCol = 0;
        }
        double X_min = this.data.getDataMinColumn(colX);
        double X_max = this.data.getDataMaxColumn(colX);
        double Y_min = this.data.getDataMinColumn(colY);
        double Y_max = this.data.getDataMaxColumn(colY);
        double range = Math.abs(X_max - X_min);
        if (range == 0.0) {
            X_max = X_min + 0.1;
        }
        double fivePercentBuffer = range * 5.0 / 100.0;
        X_max += fivePercentBuffer;
        X_min -= fivePercentBuffer;
        range = Math.abs(Y_max - Y_min);
        if (range == 0.0) {
            Y_max = Y_min + 0.1;
        }
        fivePercentBuffer = range * 5.0 / 100.0;
        Y_max += fivePercentBuffer;
        Y_min -= fivePercentBuffer;
        Point topLeft = new Point(this.outerBounds.getX(), this.outerBounds.getY());
        Point bottomRight = new Point(this.outerBounds.getX() + this.outerBounds.getWidth(), this.outerBounds.getY() + this.outerBounds.getHeight());
        DataPoint[] points = null;
        String groupName = rowGroupName = this.data.getColumnLabel(colY);
        if (scatterApp.getUseGroupByColumn()) {
            this.seriesCount = this.createSeriesHashtable(rowCount, groupCol);
        } else {
            this.seriesCount = 1;
            points = new DataPoint[rowCount];
        }
        int iconSize = scatterApp.getIconSize();
        if (iconSize <= 0) {
            iconSize = rowCount < 25 ? 15 : (rowCount < 100 ? 10 : 5);
        }
        boolean hitOne = scatterApp.getCanSelectDataPointOnly() || !scatterApp.getConnectWithLines();
        this.seriesLabels = new String[this.seriesCount];
        Enumeration<String> keyEnum = this.map.keys();
        for (int series = 0; series < this.seriesCount; ++series) {
            int row;
            int ii;
            Object o1;
            if (scatterApp.getUseGroupByColumn() && keyEnum != null) {
                Object object = o1 = this.map.keys().hasMoreElements() ? keyEnum.nextElement() : null;
                if (o1 != null) {
                    groupName = o1.toString();
                    o1 = this.map.get(groupName);
                }
                ii = o1 instanceof Number ? ((Number)o1).intValue() : 0;
                points = new DataPoint[ii];
            }
            ii = 0;
            for (row = 0; row < rowCount; ++row) {
                Object o2;
                double val2;
                double val1;
                if (scatterApp.getUseGroupByColumn()) {
                    o1 = this.data.getObjectValue(row, groupCol);
                    String string = rowGroupName = o1 == null ? null : o1.toString();
                }
                if (scatterApp.getUseGroupByColumn() && !groupName.equals(rowGroupName) || (val1 = ChartDataAdapter.toDouble(o1 = this.data.getObjectValue(row, colX))) != val1 || (val2 = ChartDataAdapter.toDouble(o2 = this.data.getObjectValue(row, colY))) != val2) continue;
                points[ii] = new DataPoint(Axis.dataToPointLinearPlane(X_min, X_max, Y_min, Y_max, topLeft, bottomRight, val1, val2), hitOne);
                points[ii].row = row;
                points[ii].column = colX;
                points[ii].hitMe = true;
                points[ii].fillColor = this.colorModel.getFillColor(row, colX, val1);
                points[ii].drawColor = this.colorModel.getOutlineColor(row, colX, val1);
                ++ii;
            }
            if (ii == 0) continue;
            if (ii < rowCount) {
                DataPoint[] points0 = new DataPoint[ii];
                while (ii-- > 0) {
                    points0[ii] = points[ii];
                }
                points = points0;
            }
            if (scatterApp.getUseGroupByColumn()) {
                groupName = "Series #" + groupName;
            }
            this.seriesLabels[series] = groupName;
            int currentIcon = this.getSeriesSymbolIcon(series);
            PointSet set = currentIcon == 0 ? new PointSet(points, scatterApp.getCharacterFont(), this.getSeriesCharacter(series, scatterApp.getCharacter())) : new PointSet(points, currentIcon, iconSize);
            row = series;
            int col = 0;
            set.fillColor = this.colorModel.getFillColor(row, col, 0.0);
            set.drawColor = this.colorModel.getOutlineColor(row, col, 0.0);
            if (scatterApp.getConnectWithLines() && set.points.length > 1) {
                scene.add(new Polyline(set.points, set.drawColor));
            }
            scene.add(set);
        }
    }

    @Override
    void validateDataForChart() {
        this.dataIsValid = this.data != null && this.data.getColumnCount() >= 2;
    }

    int createSeriesHashtable(int rowCount, int groupCol) {
        this.map.clear();
        for (int row = 0; row < rowCount; ++row) {
            String groupVal;
            double val = this.data.getValue(row, groupCol);
            String string = groupVal = val == 0.0 ? "_empty" : String.valueOf(val);
            if (this.map.containsKey(groupVal)) {
                this.map.put(groupVal, this.map.get(groupVal) + 1);
                continue;
            }
            this.map.put(groupVal, 1);
        }
        return this.map.size();
    }

    int getSeriesSymbolIcon(int seriesNumber) {
        ScatterChartAppearance scatterApp = (ScatterChartAppearance)this.getAppearance();
        int icon = scatterApp.firstIcon();
        return icon == 0 ? icon : this.firstIcon + (icon - this.firstIcon + seriesNumber) % this.symbolIconCount;
    }

    char getSeriesCharacter(int series, char character) {
        return (char)(series + character);
    }

    int getSeriesCount() {
        return this.seriesCount;
    }

    String getSeriesLabel(int index) {
        return this.seriesLabels == null || this.seriesLabels.length <= index ? "" : this.seriesLabels[index];
    }

    String[] getSeriesLabels() {
        return this.seriesLabels;
    }
}

