/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import java.util.Vector;
import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer3D;
import oracle.bpm.chart.core.layers.LabelRenderLocation;
import oracle.bpm.chart.core.primitives.Line3D;
import oracle.bpm.chart.core.primitives.Primitive;
import oracle.bpm.chart.core.primitives.Text3D;
import oracle.bpm.chart.core.primitives.Vector3D;
import oracle.bpm.chart.core.primitives.Wedge3D;
import oracle.bpm.chart.core.util.LabelFormatter;
import oracle.bpm.chart.core.util.Platform;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.data.IChartDataFilter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.PieChartAppearance;
import oracle.bpm.chart.resources.appearance.View3DAppearance;
import oracle.bpm.chart.shared.styles.LabelStyle;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Point;

public class Pie3DLayer
extends ChartLayer3D {
    public Vector<Point> others;
    int radius;
    int scale;
    int lineEnd;
    private LabelStyle labelStyle;
    private float shift = 0.0f;

    public Pie3DLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(16);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        int y0;
        int x0;
        int iRows;
        super.fillSceneGraph(scene);
        if (this.others != null) {
            this.others.removeAllElements();
        }
        if ((iRows = this.data.getRowCount()) < 1) {
            return;
        }
        PieChartAppearance pieApp = (PieChartAppearance)this.getAppearance();
        int iW = this.outerBounds.getWidth();
        int iH = this.outerBounds.getHeight();
        int pieRow = pieApp.getRowIndex();
        int iR = 1;
        if (pieRow < 0) {
            int iC = 1;
            while (iR * iC < iRows) {
                if (iW >= iH) {
                    ++iR;
                } else {
                    ++iC;
                }
                iW = this.outerBounds.getWidth() / iR;
                iH = this.outerBounds.getHeight() / iC;
            }
        } else {
            iR = 0;
            pieRow = 0;
        }
        this.radius = (iW < iH ? iW : iH) * 23 / 32;
        if (this.radius < 5) {
            this.radius = 5;
        }
        if (pieApp.getLabels().getFormat() != 0 && !pieApp.getLabelsOnPie()) {
            x0 = pieApp.getLabels().getFont().getSize() * 3 + 10;
            if (x0 > (y0 = this.radius / 3)) {
                x0 = y0;
            }
            this.radius -= x0;
        }
        if ((this.radius -= 5) < 5) {
            return;
        }
        this.scale = 10 + (int)((View3DAppearance)this.component.getChartAppearance(24)).getScale();
        this.lineEnd = this.radius + 5 + 1200 / this.scale;
        ChartCore.Environment.put("LABEL_RENDER_LOCATION", LabelRenderLocation.CHART_LAYER);
        x0 = this.outerBounds.getX() + (iW + 1) / 2;
        y0 = this.outerBounds.getY() + (iH + 1) / 2;
        if (pieRow < 0) {
            pieRow = 0;
        }
        while (pieRow < iRows) {
            int centerX = x0;
            int centerY = y0;
            if (iR != 0) {
                centerX += pieRow % iR * iW;
                centerY += pieRow / iR * iH;
            }
            scene.add(new Wedge3D(new Vector3D(centerX, centerY, 0.0f), 0.0f, 0.0f, 0.0f, -1.0f, null, null));
            this.drawRow(pieApp, scene, pieRow++);
            if (iR != 0) continue;
            break;
        }
    }

    void drawRow(PieChartAppearance pieApp, SceneGraph scene, int pieRow) {
        Wedge3D w1;
        double theta_i;
        double dataPercentage;
        int a1;
        double val;
        int colCount = this.data.getColumnCount();
        if (colCount < 1) {
            return;
        }
        float pieThickness = pieApp.getPieThickness();
        IChartDataFilter filter = null;
        if (this.data instanceof IChartDataFilter) {
            filter = (IChartDataFilter)((Object)this.data);
            pieRow = filter.getFilteredRowNumber(pieRow);
        }
        if (pieRow < 0) {
            pieRow = 0;
        }
        double cumulativeDataTotalOfRow = 0.0;
        for (int c = 0; c < colCount; ++c) {
            val = this.data.getValue(pieRow, c);
            if (val != val) continue;
            cumulativeDataTotalOfRow += Math.abs(val);
        }
        if (cumulativeDataTotalOfRow == 0.0) {
            return;
        }
        String[] colLabels = new String[colCount];
        ChartCore.Environment.put("DATA_ROW", pieRow);
        for (int c = 0; c < colCount; ++c) {
            Object dVal = this.data.getObjectValue(pieRow, c);
            val = ChartDataAdapter.toDouble(dVal);
            if (val != val) continue;
            ChartCore.Environment.put("DATA_COLUMN", c);
            ChartCore.Environment.put("ITEM_LABEL", this.data.getColumnLabel(c));
            ChartCore.Environment.put("DATA_VALUE", dVal);
            ChartCore.Environment.put("PERCENT_VALUE", Math.abs(val) * 100.0 / cumulativeDataTotalOfRow);
            colLabels[c] = LabelFormatter.replaceKeywords(pieApp.getFormatString());
        }
        int iW = pieApp.getBreakDistancePercentage();
        int breakDist = iW * this.radius / 100;
        int breakAlt = pieApp.getBreakAlternatingSlices() ? 1 : 2;
        int j = pieApp.getStartAngle();
        double startAngleDouble = j;
        this.labelStyle = new LabelStyle(pieApp.getLabels().getFont(), pieApp.getLabels().getFontColor(), false, false, false, 0, 0, 0);
        Primitive[] all = new Primitive[colCount * 3];
        int a0 = ChartCore.zeroAngle(this.core.order);
        if (a0 < j) {
            a0 += 360;
        }
        if ((a1 = a0 + 180) >= 360 + j) {
            a1 -= 360;
        }
        if (ChartCore.swapAngle(this.core.order)) {
            j = a0;
            a0 = a1;
            a1 = j;
        }
        this.shift = (float)this.radius * pieThickness / 200.0f;
        if (ChartCore.swapPie(this.core.order)) {
            this.shift = -this.shift;
        }
        iW = 0;
        int iW1 = -1;
        int iW0 = -1;
        double othersCumulativeTotal = 0.0;
        for (j = 0; j < colCount; ++j) {
            Object dVal = this.data.getObjectValue(pieRow, j);
            val = ChartDataAdapter.toDouble(dVal);
            if (val != val) continue;
            int realColNumber = filter != null ? filter.getRealColumnNumber(j) : j;
            dataPercentage = Math.abs(val) * 100.0 / cumulativeDataTotalOfRow;
            if (dataPercentage < pieApp.getOthersCategoryPercent()) {
                if (this.others == null) {
                    this.others = new Vector();
                }
                this.others.addElement(new Point(pieRow, j));
                othersCumulativeTotal += Math.abs(val);
                continue;
            }
            theta_i = startAngleDouble + 180.0 * Axis.dataToAngleLinear(0.0, cumulativeDataTotalOfRow, 0.0, Math.PI * 2, Math.abs(val)) / Math.PI;
            Point newCenter = new Point(0, 0);
            if (colCount > 1 && (pieApp.getBreakAllSlices() || breakAlt == (iW & 1) || pieApp.isSliceBroken(pieRow, realColNumber))) {
                newCenter = Axis.angularToCartesian(newCenter, breakDist, (theta_i + startAngleDouble) * Math.PI / 360.0);
            }
            w1 = new Wedge3D(new Vector3D(newCenter.getX(), newCenter.getY(), 0.0f), pieThickness, (float)startAngleDouble, (float)theta_i, this.radius, this.colorModel.getFillColor(pieRow, j, val), this.colorModel.getOutlineColor(pieRow, j, val));
            w1.row = pieRow;
            w1.column = j;
            all[iW * 3] = w1;
            if (iW0 < 0 && startAngleDouble <= (double)a0 && theta_i >= (double)a0) {
                iW0 = iW;
            }
            if (iW1 < 0 && iW0 != iW && startAngleDouble <= (double)a1 && theta_i >= (double)a1) {
                iW1 = iW;
            }
            if (pieApp.getLabels().getFormat() != 0) {
                this.addTextLabelsToScene(all, iW, colLabels[j], pieApp, newCenter, this.radius, startAngleDouble + theta_i);
            }
            startAngleDouble = theta_i;
            ++iW;
        }
        if (othersCumulativeTotal > 0.0) {
            dataPercentage = othersCumulativeTotal * 100.0 / cumulativeDataTotalOfRow;
            theta_i = startAngleDouble + 180.0 * Axis.dataToAngleLinear(0.0, cumulativeDataTotalOfRow, 0.0, Math.PI * 2, othersCumulativeTotal) / Math.PI;
            Point newCenter = new Point(0, 0);
            if (pieApp.getBreakAllSlices() || pieApp.getBreakOthersSlice() || breakAlt == (iW & 1)) {
                newCenter = Axis.angularToCartesian(newCenter, breakDist, (theta_i + startAngleDouble) * Math.PI / 360.0);
            }
            w1 = new Wedge3D(new Vector3D(newCenter.getX(), newCenter.getY(), 0.0f), pieThickness, (float)startAngleDouble, (float)theta_i, this.radius, this.colorModel.getFillColor(pieRow, colCount - 1, othersCumulativeTotal), this.colorModel.getOutlineColor(pieRow, colCount - 1, othersCumulativeTotal));
            w1.row = pieRow;
            w1.column = colCount;
            all[iW * 3] = w1;
            if (iW0 < 0 && startAngleDouble <= (double)a0 && theta_i >= (double)a0) {
                iW0 = iW;
            }
            if (iW1 < 0 && iW0 != iW && startAngleDouble <= (double)a1 && theta_i >= (double)a1) {
                iW1 = iW;
            }
            if (pieApp.getLabels().getFormat() != 0) {
                ChartCore.Environment.put("ITEM_LABEL", "");
                ChartCore.Environment.put("DATA_VALUE", othersCumulativeTotal);
                ChartCore.Environment.put("PERCENT_VALUE", dataPercentage);
                this.addTextLabelsToScene(all, iW, LabelFormatter.replaceKeywords(pieApp.getFormatString()) + " (Other)", pieApp, newCenter, this.radius, startAngleDouble + theta_i);
            }
            startAngleDouble = theta_i;
        }
        if (iW0 < 0) {
            iW0 = 0;
        }
        int bad = 0;
        if (iW1 < 0) {
            startAngleDouble = 181.0;
            a0 = -1;
            while (a1 > 360) {
                a1 -= 360;
            }
            for (j = 0; j < colCount; ++j) {
                if (!(all[j * 3] instanceof Wedge3D)) continue;
                w1 = (Wedge3D)all[j * 3];
                if (j == iW0) {
                    if (!(w1.endAngle - w1.startAngle > 180.0f)) continue;
                    bad = 1;
                    w1.skip = 1;
                    continue;
                }
                theta_i = w1.startAngle - (float)a1;
                if (theta_i < 0.0) {
                    theta_i = -theta_i;
                }
                while (theta_i > 360.0) {
                    theta_i -= 360.0;
                }
                if (theta_i > 180.0) {
                    theta_i = 360.0 - theta_i;
                }
                if (theta_i >= startAngleDouble) continue;
                startAngleDouble = theta_i;
                a0 = j;
            }
            iW1 = a0;
            if (iW1 < 0 && (iW1 = iW0 - 1) < 0) {
                iW1 = iW0 + 1;
            }
        }
        iW = iW0;
        a1 = 1;
        for (j = 0; j < colCount; ++j) {
            if (iW < 0 || iW >= colCount) continue;
            if (all[iW * 3] != null) {
                scene.add(all[iW * 3]);
            }
            iW = (iW += a1) < 0 ? colCount - 1 : (iW %= colCount);
            if (iW != iW1 || a1 <= 0) continue;
            a1 = -1;
            iW = iW0 - 1;
            if (iW >= 0) continue;
            iW = colCount - 1;
        }
        if (bad > 0 && all[iW0 * 3] != null) {
            scene.add(all[iW0 * 3]);
        }
        for (j = 0; j < colCount; ++j) {
            if (all[j * 3 + 1] != null) {
                scene.add(all[j * 3 + 1]);
            }
            if (all[j * 3 + 2] == null) continue;
            scene.add(all[j * 3 + 2]);
        }
    }

    void addTextLabelsToScene(Primitive[] all, int iW, String labelStr, PieChartAppearance pieApp, Point center, int radius, double theta) {
        int lineW = -1;
        int centerLen = 0;
        int thick = pieApp.getLabels().getBorderThickness();
        if (!pieApp.getLabelsOnPie()) {
            lineW = pieApp.getLabels().getLeaderLineThickness();
            Dimension strSize = Platform.getSize(labelStr, pieApp.getLabels().getFont());
            centerLen = thick + (int)Math.sqrt(strSize.getWidth() * strSize.getWidth() + strSize.getHeight() * strSize.getHeight());
            centerLen = centerLen * 60 / this.scale;
        }
        theta = theta * Math.PI / 360.0;
        Point textPt = Axis.angularToCartesian(center, lineW < 0 ? (double)(radius * 2 / 3) : (double)(this.lineEnd + centerLen), theta);
        Vector3D vec3D = new Vector3D(textPt.getX(), textPt.getY(), this.shift);
        Text3D t1 = new Text3D(vec3D, labelStr, this.labelStyle);
        t1.lineStyle.setDrawStyle(pieApp.getLabels().getBorderDrawStyle());
        t1.drawThickness = thick;
        t1.drawColor = pieApp.getLabels().getBorderColor();
        t1.fillColor = pieApp.getLabels().getFillColor();
        all[iW * 3 + 2] = t1;
        if (pieApp.getLabels().getLeaderLinesVisible() && lineW > 0) {
            Point leaderLineStart = Axis.angularToCartesian(center, radius * 2 / 3, theta);
            Point leaderLineEnd = Axis.angularToCartesian(center, this.lineEnd, theta);
            Vector3D vec3DLineStart = new Vector3D(leaderLineStart.getX(), leaderLineStart.getY(), this.shift);
            Vector3D vec3DLineEnd = new Vector3D(leaderLineEnd.getX(), leaderLineEnd.getY(), this.shift);
            Color c = pieApp.getLabels().getBorderColor();
            if (c == null) {
                c = Color.BLACK;
            }
            all[iW * 3 + 1] = new Line3D(vec3DLineStart, vec3DLineEnd, pieApp.getLabels().getLeaderDrawStyle(), lineW, c);
        }
    }
}

