/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.primitives.DataPoint;
import oracle.bpm.chart.core.primitives.Polyline;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.LineChartAppearance;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.geom.Point;

public class LineLayer
extends ChartLayer {
    public LineLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(15);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        LineChartAppearance lineApp = (LineChartAppearance)this.getAppearance();
        Point topLeft = this.outerBounds.getOrigin();
        Point bottomRight = new Point(this.outerBounds.getX() + this.outerBounds.getWidth(), this.outerBounds.getY() + this.outerBounds.getHeight());
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        double dataMin = this.data.getDataMin();
        double dataMax = this.data.getDataMax();
        if (rowCount < 1 || colCount < 1) {
            return;
        }
        int anchor0 = lineApp.getStartStyle();
        int anchor1 = lineApp.getEndStyle();
        int anchorSize = lineApp.getMidPointAnchors();
        if (anchorSize <= 0) {
            anchor1 = -1;
            anchor0 = -1;
        } else if (anchor0 == 0) {
            anchor1 = anchor0;
        } else if (anchor0 == 1) {
            anchor1 = 10;
        } else {
            if (anchor0 < 2) {
                anchor0 = 2;
            }
            if (anchor0 > 10) {
                anchor0 = 10;
            }
            if (anchor1 < 2) {
                anchor1 = 2;
            }
            if (anchor1 > 10) {
                anchor1 = 10;
            }
        }
        int anchor = anchor0;
        if (anchor0 == 1) {
            anchor0 = 2;
            anchor = lineApp.randomAnchor;
        }
        boolean hitOne = lineApp.getCanSelectDataPointOnly();
        int cols = colCount - 1;
        if (cols <= 0) {
            cols = 1;
        }
        for (int row = 0; row < rowCount; ++row) {
            int j0 = 0;
            DataPoint[] points = new DataPoint[colCount];
            for (int col = 0; col < colCount; ++col) {
                Object dVal = this.data.getObjectValue(row, col);
                double val = ChartDataAdapter.toDouble(dVal);
                if (val != val) continue;
                points[j0] = new DataPoint(Axis.dataToPointLinearPlane(0.0, cols, dataMin, dataMax, topLeft, bottomRight, col, val), hitOne);
                points[j0].fillColor = this.colorModel.getFillColor(row, col, val);
                points[j0].drawColor = this.colorModel.getOutlineColor(row, col, val);
                points[j0].row = row;
                points[j0].column = col;
                points[j0].hitMe = true;
                ++j0;
            }
            if (j0 == 0) continue;
            if (j0 < colCount) {
                DataPoint[] points0 = new DataPoint[j0];
                while (j0-- > 0) {
                    points0[j0] = points[j0];
                }
                points = points0;
            }
            scene.add(new Polyline(points, new LineStyle(anchor, anchorSize, lineApp.getDrawStyle()), lineApp.getThickness(), this.colorModel.getOutlineColor(row, 0, 0.0)));
            if (anchor0 > anchor1) {
                if (++anchor == anchor1) {
                    anchor = anchor0;
                    continue;
                }
                if (anchor <= 10) continue;
                anchor = 2;
                continue;
            }
            if (anchor0 >= anchor1 || ++anchor <= anchor1) continue;
            anchor = anchor0;
        }
    }
}

