/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.colormodel.SimpleColorModel;
import oracle.bpm.chart.core.layers.BubbleLayer;
import oracle.bpm.chart.core.layers.CandleLayer;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.layers.HeatMapLayer;
import oracle.bpm.chart.core.layers.Heatmap3DLayer;
import oracle.bpm.chart.core.layers.LabelRenderLocation;
import oracle.bpm.chart.core.layers.ScatterLayer;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.core.primitives.DataPoint;
import oracle.bpm.chart.core.primitives.Ellipse;
import oracle.bpm.chart.core.primitives.Line;
import oracle.bpm.chart.core.primitives.PointSet;
import oracle.bpm.chart.core.primitives.PrimitiveShape;
import oracle.bpm.chart.core.primitives.Text;
import oracle.bpm.chart.core.util.LabelFormatter;
import oracle.bpm.chart.core.util.Platform;
import oracle.bpm.chart.data.IChartData;
import oracle.bpm.chart.data.IChartDataFilter;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.BubbleChartAppearance;
import oracle.bpm.chart.resources.appearance.CandleChartAppearance;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.chart.resources.appearance.DataAppearance;
import oracle.bpm.chart.resources.appearance.LegendAppearance;
import oracle.bpm.chart.resources.appearance.ScatterChartAppearance;
import oracle.bpm.chart.shared.styles.LabelStyle;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

public class LegendLayer
extends ChartLayer {
    transient int alpha;
    transient ChartLayer chart;
    static final transient int boundsBuffer = 1;
    static final transient int iconBuffer = 3;

    public LegendLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(1);
    }

    public void setChart(ChartLayer ch) {
        this.chart = ch;
    }

    @Override
    public void setData(IChartData d) {
        this.data = d;
    }

    @Override
    public boolean isVisible() {
        return ((LegendAppearance)this.getAppearance()).getVisible();
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        Font f;
        LegendAppearance legendApp = (LegendAppearance)this.getAppearance();
        Rectangle outerDrawRect = new Rectangle(this.outerBounds.getX() + legendApp.getMargins().getLeft(), this.outerBounds.getY() + legendApp.getMargins().getTop(), this.outerBounds.getWidth() - legendApp.getMargins().getLeft() - legendApp.getMargins().getRight(), this.outerBounds.getHeight() - legendApp.getMargins().getTop() - legendApp.getMargins().getBottom());
        if (outerDrawRect.getWidth() <= 4 || outerDrawRect.getHeight() <= 4) {
            return;
        }
        int w = legendApp.getAlphaLevel();
        Box backBox = new Box(outerDrawRect);
        Color c = legendApp.getBackgroundColor();
        if (c != null && w < 255) {
            c = Color.valueOf(c.getRed(), c.getGreen(), c.getBlue(), w);
        }
        backBox.fillColor = c;
        c = legendApp.getBorderColor();
        if (c != null && w < 255) {
            c = Color.valueOf(c.getRed(), c.getGreen(), c.getBlue(), w);
        }
        backBox.drawColor = c;
        w = backBox.drawThickness = legendApp.getBorderThickness();
        backBox.lineStyle.setDrawStyle(legendApp.getBorderStyle());
        scene.add(backBox);
        Rectangle rect = new Rectangle(outerDrawRect);
        int x1 = rect.getX() + (w += 9) / 2;
        int y1 = rect.getY() + w / 2;
        int w1 = rect.getWidth() - w;
        int h1 = rect.getHeight() - w;
        rect = new Rectangle(x1, y1, w1, h1);
        if (this.colorModel == null || this.data == null || rect.getWidth() < 3 || rect.getHeight() < 3) {
            return;
        }
        Color cFore = legendApp.getFontColor();
        this.alpha = legendApp.getAlphaLevel();
        if (this.alpha < 255) {
            cFore = Color.valueOf(cFore.getRed(), cFore.getGreen(), cFore.getBlue(), this.alpha);
        }
        if ((f = legendApp.getFont()) == null) {
            f = DefaultConstants.D_LEGEND_FONT;
        }
        LabelStyle labelStyle = new LabelStyle(f, cFore, 2, 2);
        if (this.chart instanceof CandleLayer) {
            this.fillSceneCandle(scene, rect, labelStyle);
        } else if (this.chart instanceof ScatterLayer) {
            this.fillSceneScatter(scene, rect, labelStyle);
        } else if (this.chart instanceof BubbleLayer) {
            this.fillSceneBubble(scene, rect, labelStyle);
        } else if (this.chart instanceof HeatMapLayer) {
            this.fillSceneHeatMap(scene, false, rect, labelStyle);
        } else if (this.chart instanceof Heatmap3DLayer) {
            this.fillSceneHeatMap(scene, true, rect, labelStyle);
        } else {
            this.fillSceneColor(scene, rect, labelStyle);
        }
    }

    @Override
    void calculateInnerBounds() {
        LegendAppearance legendApp = (LegendAppearance)this.getAppearance();
        int i = legendApp.getSpanPercentage();
        switch (legendApp.getLocation()) {
            case 0: {
                int legendSize = this.outerBounds.getHeight() * i / 100;
                this.innerBounds = new Rectangle(this.outerBounds.getX(), this.outerBounds.getY() + legendSize, this.outerBounds.getWidth(), this.outerBounds.getHeight() - legendSize);
                this.outerBounds = new Rectangle(this.outerBounds.getX(), this.outerBounds.getY(), this.outerBounds.getWidth(), legendSize);
                break;
            }
            case 1: {
                int legendSize = this.outerBounds.getWidth() * i / 100;
                this.innerBounds = new Rectangle(this.outerBounds.getX() + legendSize, this.outerBounds.getY(), this.outerBounds.getWidth() - legendSize, this.outerBounds.getHeight());
                this.outerBounds = new Rectangle(this.outerBounds.getX(), this.outerBounds.getY(), legendSize, this.outerBounds.getHeight());
                break;
            }
            case 2: {
                int legendSize = this.outerBounds.getWidth() * i / 100;
                this.innerBounds = new Rectangle(this.outerBounds.getX(), this.outerBounds.getY(), this.outerBounds.getWidth() - legendSize, this.outerBounds.getHeight());
                this.outerBounds = new Rectangle(this.innerBounds.getX() + this.innerBounds.getWidth(), this.innerBounds.getY(), legendSize, this.innerBounds.getHeight());
                break;
            }
            case 3: {
                int legendSize = this.outerBounds.getHeight() * i / 100;
                this.innerBounds = new Rectangle(this.outerBounds.getX(), this.outerBounds.getY(), this.outerBounds.getWidth(), this.outerBounds.getHeight() - legendSize);
                this.outerBounds = new Rectangle(this.outerBounds.getX(), this.innerBounds.getY() + this.innerBounds.getHeight(), this.outerBounds.getWidth(), legendSize);
            }
        }
    }

    void fillSceneColor(SceneGraph scene, Rectangle rect, LabelStyle labelStyle) {
        int colW;
        int textH;
        int totalLegends;
        int count;
        LegendAppearance legendApp = (LegendAppearance)this.getAppearance();
        boolean colorByRow = ((ColorAppearance)this.component.getChartAppearance(6)).getColorByRow();
        if (this.colorModel instanceof SimpleColorModel) {
            colorByRow = ((SimpleColorModel)this.colorModel).colorByRow;
        }
        if (((DataAppearance)this.component.getChartAppearance(8)).getSwapRowsAndColumns()) {
            colorByRow = !colorByRow;
        }
        if ((count = (totalLegends = colorByRow ? this.data.getRowCount() : this.data.getColumnCount())) < 1) {
            return;
        }
        int rectH = textH = legendApp.getFont().getSize() * 6 / 5 + 3;
        int rows = rect.getHeight() / textH;
        if (rows < 1) {
            rows = 1;
        }
        if (rectH > (colW = rect.getWidth() / ((count - 1) / rows + 1))) {
            rectH = colW;
        }
        if (rectH < 3) {
            return;
        }
        rectH = rectH * 7 / 10;
        int rectY = (textH - rectH) / 2;
        int textX = rectH + 3;
        int textW = colW - textX;
        if (totalLegends < 1) {
            textW = 0;
        }
        ChartCore.Environment.put("LABEL_RENDER_LOCATION", LabelRenderLocation.CHART_LAYER);
        for (int i = 0; i < count; ++i) {
            int x = rect.getX() + i / rows * colW;
            int y = rect.getY() + i % rows * textH;
            Rectangle r = new Rectangle(x, y + rectY, rectH, rectH);
            Color cBack = this.colorModel.getFillColor(colorByRow ? i : 0, colorByRow ? 0 : i, 0.0);
            Color cLine = this.colorModel.getOutlineColor(colorByRow ? i : 0, colorByRow ? 0 : i, 0.0);
            if (this.alpha < 255) {
                if (cBack != null) {
                    cBack = Color.valueOf(cBack.getRed(), cBack.getGreen(), cBack.getBlue(), this.alpha);
                }
                if (cLine != null) {
                    cLine = Color.valueOf(cLine.getRed(), cLine.getGreen(), cLine.getBlue(), this.alpha);
                }
            }
            scene.add(new Box(r, cBack, cLine));
            if (textW < 5) continue;
            r = new Rectangle(x + textX, y, textW, textH);
            if (textW < 5) continue;
            String format = legendApp.getFormatString();
            ChartCore.Environment.put("DATA_VALUE", i);
            ChartCore.Environment.put("ITEM_LABEL", colorByRow ? this.data.getRowLabel(i) : this.data.getColumnLabel(i));
            scene.add(new Text(r, LabelFormatter.replaceKeywords(format), labelStyle));
        }
    }

    void fillSceneScatter(SceneGraph scene, Rectangle rect, LabelStyle labelStyle) {
        int colW;
        int rectH;
        int count;
        ScatterLayer scatter = (ScatterLayer)this.chart;
        ScatterChartAppearance scatterApp = (ScatterChartAppearance)scatter.getAppearance();
        LegendAppearance legendApp = (LegendAppearance)this.getAppearance();
        int iconSize = scatterApp.getIconSize();
        int totalLegends = scatter.getSeriesCount();
        if (totalLegends <= 0) {
            return;
        }
        if (iconSize <= 0) {
            int rowCount = scatter.data.getRowCount();
            iconSize = rowCount < 25 ? 15 : (rowCount < 100 ? 10 : 5);
        }
        if ((count = totalLegends) < 1) {
            return;
        }
        int textH = legendApp.getFont().getSize();
        if (scatter.getSeriesSymbolIcon(0) == 0) {
            rectH = scatterApp.getCharacterFont().getSize();
            if (rectH > textH) {
                textH = rectH;
            }
        } else if (textH < iconSize) {
            textH = iconSize;
        }
        rectH = textH = textH * 6 / 5 + 3;
        int rows = rect.getHeight() / textH;
        if (rows < 1) {
            rows = 1;
        }
        if (rectH > (colW = rect.getWidth() / ((count - 1) / rows + 1))) {
            rectH = colW;
        }
        if (rectH < 3) {
            return;
        }
        rectH = rectH * 7 / 10;
        int rectY = (textH - rectH) / 2;
        int textX = rectH + 3;
        int textW = colW - textX;
        for (int i = 0; i < count; ++i) {
            int x = rect.getX() + i / rows * colW;
            int y = rect.getY() + i % rows * textH;
            DataPoint[] p = new DataPoint[]{new DataPoint(x + rectH / 2, y + rectH / 2)};
            int currentIcon = scatter.getSeriesSymbolIcon(i);
            PointSet set = currentIcon == 0 ? new PointSet(p, scatterApp.getCharacterFont(), scatter.getSeriesCharacter(i, scatterApp.getCharacter())) : new PointSet(p, currentIcon, iconSize);
            Color cBack = this.colorModel.getFillColor(i, 0, 0.0);
            Color cLine = this.colorModel.getOutlineColor(i, 0, 0.0);
            if (this.alpha < 255) {
                if (cBack != null) {
                    cBack = Color.valueOf(cBack.getRed(), cBack.getGreen(), cBack.getBlue(), this.alpha);
                }
                if (cLine != null) {
                    cLine = Color.valueOf(cLine.getRed(), cLine.getGreen(), cLine.getBlue(), this.alpha);
                }
            }
            set.fillColor = cBack;
            set.drawColor = cLine;
            scene.add(set);
            if (textW < 5) continue;
            Rectangle r = new Rectangle(x + textX, y, textW, textH);
            scene.add(new Text(r, scatter.getSeriesLabel(i), labelStyle));
        }
    }

    void fillSceneBubble(SceneGraph scene, Rectangle rect, LabelStyle labelStyle) {
        BubbleLayer bubbleChart = (BubbleLayer)this.chart;
        BubbleChartAppearance bubbleApp = (BubbleChartAppearance)bubbleChart.getAppearance();
        LegendAppearance legendApp = (LegendAppearance)this.getAppearance();
        Color cBack = this.colorModel.getFillColor(0, 0, 0.0);
        Color cLine = this.colorModel.getOutlineColor(0, 0, 0.0);
        if (this.alpha < 255) {
            if (cBack != null) {
                cBack = Color.valueOf(cBack.getRed(), cBack.getGreen(), cBack.getBlue(), this.alpha);
            }
            if (cLine != null) {
                cLine = Color.valueOf(cLine.getRed(), cLine.getGreen(), cLine.getBlue(), this.alpha);
            }
        }
        int colX = bubbleApp.getColumnX();
        int colY = bubbleApp.getColumnY();
        int colZ = bubbleApp.getColumnZ();
        if (this.data instanceof IChartDataFilter) {
            IChartDataFilter filter = (IChartDataFilter)((Object)this.data);
            colX = filter.getFilteredColumnNumber(colX);
            colY = filter.getFilteredColumnNumber(colY);
            colZ = filter.getFilteredColumnNumber(colZ);
            if (colX == -1 || colY == -1 || colZ == -1) {
                colX = 0;
                colY = 1;
                colZ = 2;
            }
        }
        double min = this.data.getDataMinColumn(colZ);
        double max = this.data.getDataMaxColumn(colZ);
        if (legendApp.getLocation() == 1 || legendApp.getLocation() == 2) {
            int bubbleRadius = (int)((double)rect.getHeight() * 0.1);
            if (bubbleRadius > (rect.getWidth() - 1 - 1) / 2) {
                bubbleRadius = (rect.getWidth() - 1 - 1) / 2;
            }
            int maxRadius = bubbleRadius;
            double bubbleFactor = 0.2;
            int interBubbleSpacing = 1;
            Point currentPoint = new Point(rect.getX() + bubbleRadius + 1, rect.getY() + rect.getHeight() - bubbleRadius - 1);
            Point bottomPoint = new Point(currentPoint.getX(), currentPoint.getY());
            while (currentPoint.getY() > rect.getY() + bubbleRadius + 1) {
                Ellipse bubble = new Ellipse(currentPoint, bubbleRadius);
                bubble.drawColor = cLine;
                bubble.fillColor = cBack;
                scene.add(bubble);
                int y = currentPoint.getY() - bubbleRadius;
                bubbleRadius -= (int)((double)bubbleRadius * bubbleFactor);
                y -= bubbleRadius;
                currentPoint = new Point(currentPoint.getX(), y -= interBubbleSpacing);
            }
            Point topPoint = new Point(currentPoint.getX(), currentPoint.getY() + bubbleRadius + bubbleRadius + 1);
            int x = topPoint.getX() + 3 + maxRadius;
            x = topPoint.getX() + (rect.getX() + rect.getWidth() - topPoint.getX()) / 2;
            topPoint = new Point(x, topPoint.getY());
            bottomPoint = new Point(topPoint.getX(), bottomPoint.getY());
            Text minText = new Text(topPoint, LabelFormatter.number(min, null), labelStyle);
            Text maxText = new Text(bottomPoint, LabelFormatter.number(max, null), labelStyle);
            scene.add(minText);
            scene.add(maxText);
            Rectangle textSize = Platform.getStringSizePixels("Top Label", labelStyle.getFont());
            LineStyle lineStyle = new LineStyle();
            int y = topPoint.getY() + textSize.getHeight() + 2;
            topPoint = new Point(topPoint.getX(), y);
            y = bottomPoint.getY() - textSize.getHeight() - 2;
            bottomPoint = new Point(bottomPoint.getX(), y);
            Line arrow = new Line(topPoint, bottomPoint, lineStyle);
            arrow.drawThickness = 5;
            arrow.drawColor = labelStyle.getFontColor();
            scene.add(arrow);
        } else {
            int bubbleRadius = (rect.getHeight() - 1 - 1 - 3) / 2;
            if (bubbleRadius > (rect.getWidth() - 1 - 1) / 2) {
                bubbleRadius = (rect.getWidth() - 1 - 1) / 2;
            }
            int maxRadius = bubbleRadius;
            double bubbleFactor = 0.2;
            int interBubbleSpacing = 5;
            Point currentPoint = new Point(rect.getX() + rect.getWidth() - bubbleRadius - 1, rect.getY() + bubbleRadius + 1);
            Point bottomPoint = new Point(currentPoint.getX(), currentPoint.getY());
            while (currentPoint.getX() > rect.getX() + bubbleRadius + 1) {
                Ellipse bubble = new Ellipse(currentPoint, bubbleRadius);
                bubble.drawColor = cLine;
                bubble.fillColor = cBack;
                scene.add(bubble);
                int x = currentPoint.getX() - bubbleRadius;
                bubbleRadius -= (int)((double)bubbleRadius * bubbleFactor);
                x -= bubbleRadius;
                currentPoint = new Point(x -= interBubbleSpacing, currentPoint.getY());
            }
            Point topPoint = new Point(currentPoint.getX() + bubbleRadius + bubbleRadius + 1 + interBubbleSpacing, currentPoint.getY());
            int y = topPoint.getY() + 3 + maxRadius;
            y += (rect.getY() + rect.getHeight() - topPoint.getY()) / 2;
            topPoint = new Point(topPoint.getX(), y);
            bottomPoint = new Point(bottomPoint.getX(), topPoint.getY());
            String minString = LabelFormatter.number(min, null);
            String maxString = LabelFormatter.number(max, null);
            Text minText = new Text(topPoint, minString, labelStyle);
            Text maxText = new Text(bottomPoint, maxString, labelStyle);
            scene.add(minText);
            scene.add(maxText);
            LineStyle lineStyle = new LineStyle();
            Rectangle textSize = Platform.getStringSizePixels(minString, labelStyle.getFont());
            int x = topPoint.getX() + textSize.getWidth() + 2;
            topPoint = new Point(x, topPoint.getY());
            textSize = Platform.getStringSizePixels(maxString, labelStyle.getFont());
            x = bottomPoint.getX() - textSize.getWidth() - 2;
            bottomPoint = new Point(x, bottomPoint.getY());
            Line arrow = new Line(topPoint, bottomPoint, lineStyle);
            arrow.drawThickness = 5;
            arrow.drawColor = labelStyle.getFontColor();
            scene.add(arrow);
        }
    }

    void fillSceneHeatMap(SceneGraph scene, boolean is3D, Rectangle rect, LabelStyle labelStyle) {
        LegendAppearance legendApp = (LegendAppearance)this.getAppearance();
        Box gradientBox = null;
        Text minText = null;
        Text midText = null;
        Text maxText = null;
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        double min = this.data.getDataMin();
        double max = this.data.getDataMax();
        double mid = (max - min) / 2.0;
        Color cStart = this.colorModel.getFillColor(0, 0, 0.0);
        Color cEnd = this.colorModel.getFillColor(rowCount - 1, colCount - 1, max);
        Color cLine = this.colorModel.getOutlineColor(0, 0, 0.0);
        if (this.alpha < 255) {
            if (cStart != null) {
                cStart = Color.valueOf(cStart.getRed(), cStart.getGreen(), cStart.getBlue(), this.alpha);
            }
            if (cEnd != null) {
                cEnd = Color.valueOf(cEnd.getRed(), cEnd.getGreen(), cEnd.getBlue(), this.alpha);
            }
            if (cLine != null) {
                cLine = Color.valueOf(cLine.getRed(), cLine.getGreen(), cLine.getBlue(), this.alpha);
            }
        }
        Rectangle textSize = Platform.getStringSizePixels(String.valueOf(min), labelStyle.getFont());
        if (legendApp.getLocation() == 1 || legendApp.getLocation() == 2) {
            gradientBox = new Box(rect);
            gradientBox.fillColor = cStart;
            gradientBox.gradientFillColor = cEnd;
            Rectangle textRect = new Rectangle(rect.getX(), rect.getY() + 1, rect.getWidth(), textSize.getHeight());
            minText = new Text(textRect, LabelFormatter.number(min, null), labelStyle);
            textRect = new Rectangle(rect.getX(), rect.getY() - 1 + rect.getHeight() / 2, rect.getWidth(), textSize.getHeight());
            midText = new Text(textRect, LabelFormatter.number(mid, null), labelStyle);
            textRect = new Rectangle(rect.getX(), rect.getY() + rect.getHeight() - 1 - textSize.getHeight(), rect.getWidth(), textSize.getHeight());
            maxText = new Text(textRect, LabelFormatter.number(max, null), labelStyle);
        } else {
            gradientBox = new Box(rect);
            gradientBox.fillColor = cStart;
            gradientBox.gradientFillColor = cEnd;
            labelStyle.setOrientation(1);
            Rectangle textRect = new Rectangle(rect.getX(), rect.getY(), textSize.getHeight(), rect.getHeight());
            minText = new Text(textRect, LabelFormatter.number(min, null), labelStyle);
            textRect = new Rectangle(rect.getX() + rect.getWidth() / 2 - 1, rect.getY(), textSize.getHeight(), rect.getHeight());
            midText = new Text(textRect, LabelFormatter.number(mid, null), labelStyle);
            textRect = new Rectangle(rect.getX() + rect.getWidth() - textSize.getHeight() - 1, rect.getY(), textSize.getHeight(), rect.getHeight());
            maxText = new Text(textRect, LabelFormatter.number(max, null), labelStyle);
        }
        scene.add(gradientBox);
        scene.add(minText);
        scene.add(midText);
        scene.add(maxText);
    }

    void fillSceneCandle(SceneGraph scene, Rectangle rect, LabelStyle labelStyle) {
        int colW;
        int textH;
        LegendAppearance legendApp = (LegendAppearance)this.getAppearance();
        int totalLegends = 4;
        int rectH = textH = legendApp.getFont().getSize() * 6 / 5 + 3;
        int rows = rect.getHeight() / textH;
        if (rows < 1) {
            rows = 1;
        }
        if (rectH > (colW = rect.getWidth() / ((totalLegends - 1) / rows + 1))) {
            rectH = colW;
        }
        if (rectH < 3) {
            return;
        }
        rectH = rectH * 7 / 10;
        int rectY = (textH - rectH) / 2;
        int textX = rectH + 3;
        int textW = colW - textX;
        CandleChartAppearance cdApp = (CandleChartAppearance)this.component.getChartAppearance(25);
        for (int i = 0; i < totalLegends; ++i) {
            int x = rect.getX() + i / rows * colW;
            int y = rect.getY() + i % rows * textH;
            Rectangle r = new Rectangle(x, y + rectY, rectH, rectH);
            Color cLine = this.colorModel.getOutlineColor(0, 0, 0.0);
            Color cBack = cdApp.getVolumeColor();
            switch (i) {
                case 0: {
                    cBack = cdApp.getNegativeRangeColor();
                    break;
                }
                case 1: {
                    cBack = cdApp.getPositiveRangeColor();
                    break;
                }
                case 2: {
                    cBack = cdApp.getWickColor();
                }
            }
            if (this.alpha < 255) {
                if (cBack != null) {
                    cBack = Color.valueOf(cBack.getRed(), cBack.getGreen(), cBack.getBlue(), this.alpha);
                }
                if (cLine != null) {
                    cLine = Color.valueOf(cLine.getRed(), cLine.getGreen(), cLine.getBlue(), this.alpha);
                }
            }
            PrimitiveShape pShape = null;
            if (i == 0 || i == 1) {
                pShape = new Box(new Point(x + rectH / 4, r.getY()), rectH / 2, rectH);
            } else if (i == 2) {
                pShape = new Line(new Point(x + rectH / 2, r.getY()), new Point(x + rectH / 2, r.getY() + r.getWidth()));
                cLine = cBack;
                pShape.drawThickness = ((CandleChartAppearance)this.component.getChartAppearance(25)).getWickThickness();
            } else if (i == 3) {
                pShape = new Box(r);
            }
            pShape.drawColor = cLine;
            pShape.fillColor = cBack;
            scene.add(pShape);
            if (textW < 5) continue;
            r = new Rectangle(x + textX, y, textW, textH);
            String lbl = "Volume";
            switch (i) {
                case 0: {
                    lbl = "Open Higher";
                    break;
                }
                case 1: {
                    lbl = "Close Higher";
                    break;
                }
                case 2: {
                    lbl = "Highest/Lowest";
                }
            }
            scene.add(new Text(r, lbl, labelStyle));
        }
    }
}

