/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer3D;
import oracle.bpm.chart.core.primitives.Box3D;
import oracle.bpm.chart.core.primitives.Vector3D;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.ColumnChartAppearance;

public class Column3DLayer
extends ChartLayer3D {
    public Column3DLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(13);
    }

    @Override
    public String getDataInvalidMessage() {
        if (((ColumnChartAppearance)this.component.getChartAppearance(13)).getStack()) {
            return "Stacked BasicChartComponent Error: data should be either all positive or negative";
        }
        return super.getDataInvalidMessage();
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        super.fillSceneGraph(scene);
        ColumnChartAppearance columnApp = (ColumnChartAppearance)this.getAppearance();
        if (columnApp.getStack()) {
            this.fillSceneGraphStacked(scene);
            return;
        }
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        double dataMin = this.core.dataMin;
        double dataMax = this.core.dataMax;
        int space = columnApp.getColumnSpacing();
        if (space < 0) {
            space = 0;
        }
        if (space > 100) {
            space = 100;
        }
        double barWidth = Axis.setDataItemWidth(rowCount, rowCount, space, space, (int)this.volume.z);
        double barLength = Axis.setDataItemWidth(colCount, colCount, space, space, (int)this.volume.x);
        double xZero = ((double)(this.volume.x / (float)colCount) - barLength) / 2.0;
        double zZero = ((double)(this.volume.z / (float)rowCount) - barWidth) / 2.0;
        double zero = 0.0;
        if (dataMax < 0.0) {
            zero = dataMax;
        } else if (dataMin > 0.0) {
            zero = dataMin;
        }
        for (int ii = 0; ii < rowCount; ++ii) {
            for (int jj = 0; jj < colCount; ++jj) {
                int j;
                int i = this.core.flipRow ? rowCount - 1 - ii : ii;
                Object dVal = this.data.getObjectValue(i, j = this.core.flipCol ? colCount - 1 - jj : jj);
                double val = ChartDataAdapter.toDouble(dVal);
                if (val != val) continue;
                double x = Axis.dataToDoubleLinear(0.0, colCount, -this.volume.x / 2.0f, this.volume.x / 2.0f, j) + xZero;
                double y = Axis.dataToDoubleLinear(dataMin, dataMax, 0.0, this.volume.y, zero);
                double z = (double)((float)Axis.dataToDoubleLinear(0.0, rowCount, -this.volume.z / 2.0f, this.volume.z / 2.0f, i)) + zZero;
                double x1 = x + barLength;
                double y1 = Axis.dataToDoubleLinear(dataMin, dataMax, 0.0, this.volume.y, val);
                double z1 = z + barWidth;
                if (y > y1) {
                    double y2 = y1;
                    y1 = y;
                    y = y2;
                }
                Box3D b = new Box3D(new Vector3D(x, y, z), new Vector3D(x1, y1, z1), this.colorModel.getFillColor(i, j, val), this.colorModel.getOutlineColor(i, j, val));
                b.column = j;
                b.row = i;
                b.hitMe = true;
                b.negative = val < zero;
                scene.add(b);
            }
        }
    }

    public void fillSceneGraphStacked(SceneGraph scene) {
        boolean negative;
        double barWidth;
        double zZero;
        double xZero;
        ColumnChartAppearance columnApp = (ColumnChartAppearance)this.getAppearance();
        int stackStyle = columnApp.getStackStyle();
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        double oldval = 0.0;
        double dataMin = this.core.dataMin;
        double dataMax = this.core.dataMax;
        int space = columnApp.getColumnSpacing();
        if (space < 0) {
            space = 0;
        }
        if (space > 100) {
            space = 100;
        }
        if ((xZero = (zZero = ((double)(this.volume.z / (float)rowCount) - (barWidth = Axis.setDataItemWidth(rowCount, rowCount, space, space, (int)this.volume.z))) / 2.0)) * 3.0 > (double)this.volume.x) {
            xZero = this.volume.x / 3.0f;
        }
        double barLength = (double)this.volume.x - xZero * 2.0;
        boolean bl = negative = dataMax <= 0.0;
        if (stackStyle == 1) {
            if (negative) {
                dataMax = 0.0;
            } else {
                dataMin = 0.0;
            }
        }
        Box3D[] row = new Box3D[colCount];
        for (int ii = 0; ii < rowCount; ++ii) {
            int j;
            double val;
            int i = this.core.flipRow ? rowCount - 1 - ii : ii;
            double factor = 1.0;
            if (stackStyle == 1) {
                val = ChartCore.getStackedRowValue(this.data, i, colCount);
                if (val == 0.0) continue;
                factor = negative ? dataMin / val : dataMax / val;
            }
            val = 0.0;
            for (j = 0; j < colCount; ++j) {
                row[j] = null;
                oldval = val;
                double v = this.data.getValue(i, j);
                if (v != v || v == 0.0 || (val += v) < dataMin || val > dataMax) continue;
                if (oldval < dataMin) {
                    oldval = dataMin;
                }
                if (oldval > dataMax) {
                    oldval = dataMax;
                }
                double x = Axis.dataToDoubleLinear(0.0, colCount, -this.volume.x / 2.0f, this.volume.x / 2.0f, 0.0) + xZero;
                double y = Axis.dataToDoubleLinear(dataMin, dataMax, 0.0, this.volume.y, oldval * factor);
                double z = Axis.dataToDoubleLinear(0.0, rowCount, -this.volume.z / 2.0f, this.volume.z / 2.0f, i) + zZero;
                double x1 = x + barLength;
                double y1 = Axis.dataToDoubleLinear(dataMin, dataMax, 0.0, this.volume.y, val * factor);
                double z1 = z + barWidth;
                if (negative) {
                    v = y1;
                    y1 = y;
                    y = v;
                }
                Box3D b = new Box3D(new Vector3D(x, y, z), new Vector3D(x1, y1, z1), this.colorModel.getFillColor(i, j, val), this.colorModel.getOutlineColor(i, j, val));
                b.column = j;
                b.row = i;
                b.hitMe = true;
                row[j] = b;
            }
            for (j = 0; j < colCount; ++j) {
                boolean flip = this.core.flipCol;
                if (negative) {
                    flip = !flip;
                }
                int n = i = flip ? colCount - 1 - j : j;
                if (row[i] == null) continue;
                scene.add(row[i]);
            }
        }
    }

    @Override
    void validateDataForChart() {
        super.validateDataForChart();
        ColumnChartAppearance type = (ColumnChartAppearance)this.component.getChartAppearance(13);
        if (type.getStack() && (this.data == null || this.data.getDataMin() < 0.0 && this.data.getDataMax() > 0.0)) {
            this.dataIsValid = false;
        }
    }
}

