/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.colormodel.IColorModel;
import oracle.bpm.chart.core.layers.Layer;
import oracle.bpm.chart.data.ChartDataFilter;
import oracle.bpm.chart.data.IChartData;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.DataAppearance;
import oracle.bpm.chart.shared.styles.ChartType;

public abstract class ChartLayer
extends Layer {
    transient IColorModel colorModel;
    transient boolean dataIsValid = false;

    public ChartLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    public void setColorModel(IColorModel clrMdl) {
        this.colorModel = clrMdl;
    }

    public IColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public void setData(IChartData data) {
        super.setData(data);
        this.setupDataFilter();
    }

    public boolean isDataValidForChart() {
        this.validateDataForChart();
        return this.dataIsValid;
    }

    void setupDataFilter() {
        boolean foundRowLabels;
        if (!(this.data instanceof ChartDataFilter)) {
            return;
        }
        ChartDataFilter filter = (ChartDataFilter)this.data;
        DataAppearance dataApp = (DataAppearance)this.component.getChartAppearance(8);
        filter.resetColumnList();
        IChartData rawData = filter.getRawData();
        int i = -1;
        int iCount = rawData.getRowCount();
        while (++i < iCount) {
            if (!dataApp.isRowIncluded(i)) continue;
            filter.includeRow(i);
        }
        i = -1;
        iCount = rawData.getColumnCount();
        boolean bl = foundRowLabels = this.core.getChartType() != ChartType.CANDLE_CHART;
        while (++i < iCount) {
            int type = filter.getRawColumnType(i);
            if (type == 1) {
                if (dataApp.isColumnExcluded(i)) continue;
                filter.includeColumn(i, true);
                continue;
            }
            if (type != 3 || foundRowLabels || dataApp.isColumnExcluded(i)) continue;
            filter.includeColumn(i, true);
            rawData.setRowLabelsColumn(i);
            rawData.setUseRowLabels(true);
            foundRowLabels = true;
        }
    }

    void validateDataForChart() {
        this.dataIsValid = this.data != null && this.data.getColumnCount() > 0 && this.data.getRowCount() > 0;
    }
}

