/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Layer;
import oracle.bpm.chart.core.primitives.Box;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.BorderAppearance;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

public class BorderLayer
extends Layer {
    public BorderLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(0);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        super.fillSceneGraph(scene);
        BorderAppearance borderApp = (BorderAppearance)this.getAppearance();
        if (borderApp.getThickness() <= 0) {
            return;
        }
        int halfBorder = borderApp.getThickness() / 2;
        Box box = new Box(new Point(this.outerBounds.getX() + halfBorder, this.outerBounds.getY() + halfBorder), this.outerBounds.getWidth() - borderApp.getThickness(), this.outerBounds.getHeight() - borderApp.getThickness());
        box.fillColor = null;
        box.drawColor = borderApp.getColor();
        box.drawThickness = borderApp.getThickness();
        box.lineStyle = new LineStyle();
        box.lineStyle.setDrawStyle(borderApp.getDrawStyle());
        scene.add(box);
    }

    @Override
    void calculateInnerBounds() {
        BorderAppearance borderApp = (BorderAppearance)this.getAppearance();
        this.innerBounds = new Rectangle(this.outerBounds.getX() + borderApp.getThickness(), this.outerBounds.getY() + borderApp.getThickness(), this.outerBounds.getWidth() - borderApp.getThickness() * 2, this.outerBounds.getHeight() - borderApp.getThickness() * 2);
    }
}

