/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer3D;
import oracle.bpm.chart.core.layers.LabelRenderLocation;
import oracle.bpm.chart.core.primitives.Line3D;
import oracle.bpm.chart.core.primitives.Text3D;
import oracle.bpm.chart.core.primitives.Vector3D;
import oracle.bpm.chart.core.util.LabelFormatter;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.AxisAppearance;
import oracle.bpm.chart.shared.styles.LabelStyle;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.draw.Color;

class Axis3D
extends ChartLayer3D {
    AxisAppearance axisApp;
    int axisNumber;
    float dataMin;
    float dataMax;
    int drawingStyle = 1311238;
    int id;
    int itemCount = 10;
    String itemLabelFormat = DefaultConstants.D_AXIS_LABEL_FORMAT_DATA;
    Text3D[] labels;
    LabelStyle labelStyle = new LabelStyle();
    Color majorGridLineColor = DefaultConstants.D_AXIS_MAJOR_GRID_LINE_COLOR;
    LineStyle majorGridLineStyle = new LineStyle();
    int majorGridLineThickness = DefaultConstants.D_LINE_THICKNESS;
    Vector3D spanPlane;
    Vector3D startPoint;
    Vector3D endPoint;
    String[] strLabels;
    double tickInterval = DefaultConstants.D_AXIS_TICK_INTERVAL;
    double tickPercentage = DefaultConstants.D_AXIS_TICK_PERCENTAGE;

    Axis3D(IChartComponent component, ChartCore core, int axisNum) {
        super(component, core);
        this.startPoint = new Vector3D();
        this.endPoint = new Vector3D();
        this.axisNumber = axisNum;
    }

    static Vector3D axisDataPointLinear3D(Vector3D startPoint, Vector3D endPoint, float dataMin, float dataMax, float d_i) {
        if (dataMax == dataMin) {
            return startPoint;
        }
        Vector3D result = new Vector3D();
        float factor = (d_i - dataMin) / (dataMax - dataMin);
        result.x = startPoint.x + Math.abs(endPoint.x - startPoint.x) * factor;
        result.y = startPoint.y + Math.abs(endPoint.y - startPoint.y) * factor;
        result.z = startPoint.z + Math.abs(endPoint.z - startPoint.z) * factor;
        return result;
    }

    static Vector3D dataTo3DLinearSpace(Vector3D volume, double YMin, double YMax, double YVal, int rows, int cols, int XCurr, int ZCurr) {
        float x = (float)Axis.dataToDoubleLinear(0.0, cols - 1, 0.0, volume.x, XCurr);
        float y = (float)Axis.dataToDoubleLinear(YMin, YMax, 0.0, volume.y, YVal);
        float z = (float)Axis.dataToDoubleLinear(0.0, rows - 1, 0.0, volume.z, ZCurr);
        return new Vector3D(x, y, z);
    }

    void drawEdge(SceneGraph scene) {
        if ((this.drawingStyle & 0x100) > 0) {
            scene.add(new Line3D(this.startPoint, this.endPoint, this.majorGridLineStyle, this.majorGridLineThickness, this.majorGridLineColor));
        }
    }

    void drawSpan(SceneGraph scene, Vector3D p_i) {
        if ((this.drawingStyle & 0x120) == 0) {
            return;
        }
        Vector3D p2 = p_i;
        if ((this.drawingStyle & 0x100) != 0 && this.majorGridLineThickness > 0) {
            p2 = Vector3D.add(p_i, this.spanPlane);
        }
        Line3D line = new Line3D(p_i, p2, this.majorGridLineStyle, this.majorGridLineThickness, this.majorGridLineColor);
        if ((this.drawingStyle & 0x20) != 0) {
            line.fillColor = this.majorGridLineColor;
        }
        scene.add(line);
    }

    void addLabel(Vector3D p_i, int i) {
        String txt = LabelFormatter.replaceKeywords(this.itemLabelFormat);
        if (this.id >= 16 && txt.length() > 2) {
            this.id &= 7;
        }
        this.labels[i] = new Text3D(p_i, txt, this.labelStyle);
    }

    void drawLabels(SceneGraph scene) {
        if (this.labels == null) {
            return;
        }
        int i = this.labels.length;
        while (i-- > 0) {
            if (this.labels[i] == null) continue;
            this.labels[i].id = this.id;
            scene.add(this.labels[i]);
        }
    }

    void retrieveAppearanceProperties() {
        if (this.axisApp == null) {
            return;
        }
        this.setVisible(this.axisApp.getVisible());
        this.setStyle(786432, this.axisApp.getLabels().getVisible());
        this.setStyle(256, this.axisApp.getMajorGridLines().getVisible());
        this.setStyle(32, this.axisApp.getMajorGridLines().getTickmarksVisible());
        this.majorGridLineColor = this.axisApp.getMajorGridLines().getColorWithAlpha();
        this.majorGridLineStyle.setDrawStyle(this.axisApp.getMajorGridLines().getDrawStyle());
        this.majorGridLineThickness = this.axisApp.getMajorGridLines().getLineThickness();
        this.labelStyle.setFont(this.axisApp.getLabels().getFont());
        this.labelStyle.setFontColor(this.axisApp.getLabels().getFontColor());
        this.itemLabelFormat = this.axisApp.getLabels().getItemFormatString();
        this.tickInterval = this.axisApp.getTickmarkInterval();
        this.tickPercentage = this.axisApp.getTickmarkPercentage();
        switch (this.axisApp.getTickmarkStyle()) {
            case 0: {
                this.addStyle(8);
                this.removeStyle(20);
                break;
            }
            case 1: {
                this.addStyle(4);
                this.removeStyle(24);
            }
        }
        this.id |= 0x10;
        if ((this.drawingStyle & 0x40000) == 0) {
            this.labels = null;
        } else {
            ChartCore.Environment.put("LABEL_RENDER_LOCATION", LabelRenderLocation.AXIS);
        }
    }

    void addStyle(int st) {
        this.drawingStyle |= st;
    }

    void removeStyle(int st) {
        this.drawingStyle &= ~st;
    }

    void setStyle(int st) {
        this.drawingStyle = st;
    }

    void setStyle(int st, boolean set) {
        if (set && this.isVisible()) {
            this.addStyle(st);
        } else {
            this.removeStyle(st);
        }
    }
}

