/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import java.util.Date;
import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Layer;
import oracle.bpm.chart.core.layers.TimeSpan;
import oracle.bpm.chart.core.primitives.Line;
import oracle.bpm.chart.core.util.MiscFunctions;
import oracle.bpm.chart.resources.DefaultConstants;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.AxisAppearance;
import oracle.bpm.chart.resources.appearance.AxisLabelAppearance;
import oracle.bpm.chart.shared.styles.LabelStyle;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;

class Axis
extends Layer {
    int axisNumber;
    int axisType;
    double dataMin;
    double dataMax;
    int dateDataColumn = -1;
    TimeSpan dateInterval = new TimeSpan(1, 0, 0, 0);
    int dateSkipN = 0;
    int drawingStyle = 1311238;
    int interItemSpacing = DefaultConstants.D_BAR_COLUMN_CHART_SERIES_SPACING;
    int interSeriesSpacing = DefaultConstants.D_BAR_COLUMN_CHART_INTER_SPACING;
    String itemLabelFormat = DefaultConstants.D_AXIS_LABEL_FORMAT_DATA;
    LabelStyle labelStyle;
    Color lineColor = DefaultConstants.D_TEXT_COLOR;
    LineStyle lineStyle = new LineStyle();
    int lineThickness = DefaultConstants.D_AXIS_THICKNESS;
    Color majorGridLineColor = DefaultConstants.D_AXIS_MAJOR_GRID_LINE_COLOR;
    LineStyle majorGridLineStyle = new LineStyle();
    int majorGridLineThickness = DefaultConstants.D_LINE_THICKNESS;
    Color minorGridLineColor = DefaultConstants.D_AXIS_MINOR_GRID_LINE_COLOR;
    LineStyle minorGridLineStyle = new LineStyle();
    int minorGridLineThickness = DefaultConstants.D_LINE_THICKNESS;
    String seriesLabelFormat = DefaultConstants.D_AXIS_LABEL_FORMAT_SERIES;
    LabelStyle seriesLabelStyle = new LabelStyle();
    int span_1;
    int span_2;
    boolean stack = false;
    Date startDate;
    Date endDate;
    Point startPoint;
    Point axisLineEnd = this.startPoint = new Point(0, 0);
    Point axisLineStart = this.startPoint;
    Point endPoint = this.startPoint;
    int extent = 0;
    int gap = 2;
    String[] labels;
    int majorTick = 0;
    int minorTick = 0;
    double tickInterval = DefaultConstants.D_AXIS_TICK_INTERVAL;
    double tickPercentage = DefaultConstants.D_AXIS_TICK_PERCENTAGE;
    static final int MATH_STYLE_LOG = 1;
    static final int MATH_STYLE_LINEAR = 2;
    static final int TICK_STYLE_PERCENTAGE = 4;
    static final int TICK_STYLE_DATA_INTERVAL = 8;
    static final int TICK_STYLE_DATA_VALUE = 16;
    static final int MAJOR_TICK_VISIBLE = 32;
    static final int MINOR_TICK_VISIBLE = 64;
    static final int MAJOR_GRID_LINE_VISIBLE = 256;
    static final int MINOR_GRID_LINE_VISIBLE = 512;
    static final int DOCKING_STYLE_LEFT = 1024;
    static final int DOCKING_STYLE_RIGHT = 2048;
    static final int DOCKING_STYLE_TOP = 4096;
    static final int DOCKING_STYLE_BOTTOM = 8192;
    static final int ORIENTATION_HORIZONTAL = 32768;
    static final int ORIENTATION_VERTICAL = 65536;
    static final int ORIENTATION_ANGULAR = 131072;
    static final int MAJOR_LABEL_VISIBLE = 262144;
    static final int MINOR_LABEL_VISIBLE = 524288;
    static final int AXIS_LINE_VISIBLE = 0x100000;
    static final int D_AXIS_DRAW_STYLE = 1311238;
    static final int NUMERIC_DATA = 0;
    static final int ITEM_ROW_LABELING = 1;
    static final int ITEM_COLUMN_LABELING = 2;
    static final int DATE_DATA = 3;
    static final int GROUP_BY_SERIES = 4;

    public Axis(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    Axis(IChartComponent component, ChartCore core, int axisNum, int type) {
        super(component, core);
        this.axisType = type;
        this.axisNumber = axisNum;
        this.labelStyle = new LabelStyle(DefaultConstants.D_AXIS_LABEL_FONT, Color.BLACK, false, false, false, 0, 0, axisNum == 1 ? DefaultConstants.D_AXIS_Y_LABEL_ORIENTATION : DefaultConstants.D_AXIS_X_LABEL_ORIENTATION);
    }

    static Point dataToPointLinearPlane(double dataHorzMin, double dataHorzMax, double dataVertMin, double dataVertMax, Point leftTop, Point bottomRight, double d_h, double d_v) {
        Point P1_horz = new Point(leftTop.getX(), bottomRight.getY());
        Point P2_horz = bottomRight;
        Point P1_vert = P1_horz;
        Point P2_vert = leftTop;
        int x = Axis.dataToPointLinearHorizontal(dataHorzMin, dataHorzMax, P1_horz, P2_horz, d_h).getX();
        int y = Axis.dataToPointLinearVertical(dataVertMin, dataVertMax, P1_vert, P2_vert, d_v).getY();
        Point result = new Point(x, y);
        return result;
    }

    static Point dataToPointLinearVertical(double dataMin, double dataMax, Point p1, Point p2, double d_i) {
        if (dataMax == dataMin) {
            return p1;
        }
        int x = p1.getX();
        int y = p1.getY() - (int)((double)Math.abs(p2.getY() - p1.getY()) * (d_i - dataMin) / Math.abs(dataMax - dataMin));
        Point result = new Point(x, y);
        return result;
    }

    static Point dataToPointLinearHorizontal(double dataMin, double dataMax, Point p1, Point p2, double d_i) {
        if (dataMax == dataMin) {
            return p1;
        }
        int x = p1.getX() + (int)((double)Math.abs(p2.getX() - p1.getX()) * (d_i - dataMin) / Math.abs(dataMax - dataMin));
        int y = p1.getY();
        Point result = new Point(x, y);
        return result;
    }

    static double dataToDoubleLinear(double dataMin, double dataMax, double p1, double p2, double d_i) {
        p1 = Math.abs(p2 - p1);
        if (dataMax != dataMin) {
            p1 = p1 * (d_i - dataMin) / (dataMax - dataMin);
        }
        return p1;
    }

    static Point angularToCartesian(Point center, double radius, double theta) {
        int x = center.getX() + (int)(radius * Math.cos(theta));
        int y = center.getY() + (int)(radius * Math.sin(theta));
        Point result = new Point(x, y);
        return result;
    }

    static double dataToAngleLinear(double dataMin, double dataMax, double thetaMin, double thetaMax, double d_i) {
        return dataMax != dataMin ? thetaMax * d_i / (dataMax - dataMin) : (thetaMax -= thetaMin);
    }

    static int itemPoint(int itemCount, int colCount, int rowSpace, int colSpace, int totalWidth, int i) {
        int iRows;
        if (colCount < 1) {
            colCount = 1;
        }
        if ((iRows = itemCount / colCount) == 0) {
            iRows = 1;
        }
        int iRowW = totalWidth / iRows;
        int iW = iRowW / colCount;
        int iRowSpace = iW - (int)((double)iW / (1.0 + (double)rowSpace * 0.1) + 0.5);
        if (i == -2) {
            return iRowSpace / 2;
        }
        iW = (iRowW - iRowSpace) / colCount;
        if (i == -3) {
            return (iW - (int)((double)iW / (1.0 + (double)colSpace * 0.1) + 0.5)) / 2;
        }
        if (i == -1) {
            return (int)((double)iW / (1.0 + (double)colSpace * 0.1) + 0.5);
        }
        int iCol = colCount > 1 ? i % colCount : 0;
        iW = iW * iCol + iRowW * (i / colCount);
        if (i == itemCount) {
            return totalWidth - iW;
        }
        return iW + iRowSpace / 2;
    }

    static int setDataItemLinear(int itemCount, int inSetCount, int totalWidth, int item_i) {
        return (int)((double)item_i * Axis.setDataItemWidth(itemCount, inSetCount, 0, 0, totalWidth));
    }

    static double setDataItemWidth(int itemCount, int inSetCount, int interSeriesSpacing, int interBarSpacing, int totalWidth) {
        double numOfSets = inSetCount < 1 ? (double)itemCount : (double)(itemCount / inSetCount);
        double newCount = (double)interSeriesSpacing * 0.1 * (numOfSets - 1.0) + (double)interBarSpacing * 0.1 * (double)(inSetCount - 1) * numOfSets + (double)itemCount;
        return newCount < 1.0 ? (double)totalWidth : (double)totalWidth / newCount;
    }

    static float dateDataDateLinear(Date startDate, Date endDate, float totalWidth, Date d_i) {
        long startTick = startDate.getTime();
        long endTick = endDate.getTime();
        long d_iTick = d_i.getTime();
        long delta = endTick - startTick;
        if (delta == 0L) {
            return 0.0f;
        }
        return (float)(d_iTick - startTick) * totalWidth / (float)delta;
    }

    static Color data2ColorLinear(Color startColor, Color endColor, double DataMax, double DataMin, double val, int alpha) {
        int colorDistance = MiscFunctions.distance(endColor, startColor);
        double percent = DataMax == DataMin ? 0.0 : (val - DataMin) / (DataMax - DataMin);
        int colorDistanceDelta = (int)((double)colorDistance * percent);
        if (colorDistance == 0) {
            colorDistance = 1;
        }
        int R = startColor.getRed() + colorDistanceDelta * (endColor.getRed() - startColor.getRed()) / colorDistance;
        int G = startColor.getGreen() + colorDistanceDelta * (endColor.getGreen() - startColor.getGreen()) / colorDistance;
        int B = startColor.getBlue() + colorDistanceDelta * (endColor.getBlue() - startColor.getBlue()) / colorDistance;
        R = R > 255 ? 255 : R;
        G = G > 255 ? 255 : G;
        B = B > 255 ? 255 : B;
        R = R < 0 ? 0 : R;
        G = G < 0 ? 0 : G;
        B = B < 0 ? 0 : B;
        return Color.valueOf(R, G, B, alpha);
    }

    void retrieveAppearanceProperties() {
        int o;
        AxisAppearance axisApp = (AxisAppearance)this.component.getChartAppearance(this.axisNumber == 0 ? 9 : 10);
        if (axisApp == null) {
            return;
        }
        AxisLabelAppearance lbl = axisApp.getLabels();
        this.setVisible(axisApp.getVisible());
        this.extent = axisApp.getExtent();
        this.lineThickness = axisApp.getLineThickness();
        this.lineColor = axisApp.getLineColor();
        int ext = axisApp.getLineDrawStyle();
        if (ext == DefaultConstants.D_AXIS_DEFAULT_LINE_STYLE) {
            ext = DefaultConstants.D_AXIS_2D_LINE_STYLE;
        }
        this.lineStyle.setDrawStyle(ext);
        this.setStyle(256, axisApp.getMajorGridLines().getVisible());
        boolean minor = this.axisType != 1 && this.axisType != 2;
        this.minorTick = 0;
        this.majorTick = 0;
        if (axisApp.getMinorGridLines().getTickmarksVisible() && minor) {
            this.minorTick = 2 + this.lineThickness;
        }
        if (axisApp.getMajorGridLines().getTickmarksVisible()) {
            this.majorTick = (this.minorTick != 0 ? 4 : 2) + this.lineThickness;
        }
        if ((this.gap = this.majorTick) == 0 && (this.gap = this.minorTick) == 0) {
            this.gap = this.lineThickness / 2;
        }
        this.majorGridLineColor = axisApp.getMajorGridLines().getColorWithAlpha();
        this.majorGridLineStyle.setDrawStyle(axisApp.getMajorGridLines().getDrawStyle());
        this.majorGridLineThickness = axisApp.getMajorGridLines().getLineThickness();
        int vert = 0;
        int hor = 0;
        this.setStyle(512, axisApp.getMinorGridLines().getVisible() && minor);
        if (minor) {
            this.minorGridLineColor = axisApp.getMinorGridLines().getColorWithAlpha();
            this.minorGridLineStyle.setDrawStyle(axisApp.getMinorGridLines().getDrawStyle());
            this.minorGridLineThickness = axisApp.getMinorGridLines().getLineThickness();
            if (this.axisType == 4) {
                this.seriesLabelFormat = lbl.getSeriesFormatString();
                this.seriesLabelStyle.setFont(lbl.getFont());
                this.seriesLabelStyle.setFontColor(lbl.getFontColor());
                this.seriesLabelStyle.setOrientation(this.stack && this.axisNumber == 1 ? lbl.getOrientation() : lbl.getSeriesOrientation());
                o = this.seriesLabelStyle.getOrientation();
                if (o == 0) {
                    if (this.axisNumber == 0) {
                        vert = this.stack ? 2 : 1;
                    } else {
                        hor = this.stack ? 1 : 2;
                    }
                } else if (this.axisNumber == 0) {
                    hor = o == 2 ? (this.stack ? 2 : 1) : (this.stack ? 1 : 2);
                } else {
                    vert = o == 2 ? (this.stack ? 2 : 1) : (this.stack ? 1 : 2);
                }
                this.seriesLabelStyle.setHorizontalAlign(hor);
                this.seriesLabelStyle.setVerticalAlign(vert);
            }
        }
        this.labelStyle.setFont(lbl.getFont());
        this.labelStyle.setFontColor(lbl.getFontColor());
        this.labelStyle.setOrientation(lbl.getOrientation());
        hor = 0;
        vert = 0;
        o = this.labelStyle.getOrientation();
        if (o == 0) {
            if (this.axisNumber == 0) {
                vert = 2;
            } else {
                hor = 1;
            }
        } else if (this.axisNumber == 0) {
            hor = o == 2 ? 2 : 1;
        } else {
            vert = o == 2 ? 2 : 1;
        }
        this.labelStyle.setHorizontalAlign(hor);
        this.labelStyle.setVerticalAlign(vert);
        this.itemLabelFormat = lbl.getItemFormatString();
        this.setStyle(786432, lbl.getVisible() && (this.extent < 0 || this.extent > 7));
        this.tickInterval = axisApp.getTickmarkInterval();
        this.tickPercentage = axisApp.getTickmarkPercentage();
        switch (axisApp.getTickmarkStyle()) {
            case 0: {
                this.addStyle(8);
                this.removeStyle(20);
                break;
            }
            case 1: {
                this.addStyle(4);
                this.removeStyle(24);
            }
        }
        ext = this.getExtent();
        if (this.axisNumber == 0) {
            this.innerBounds = new Rectangle(this.innerBounds.getX(), this.innerBounds.getY(), this.innerBounds.getWidth(), this.outerBounds.getHeight() - ext);
            this.span_1 = this.innerBounds.getY();
            this.span_2 = this.innerBounds.getY() + this.innerBounds.getHeight();
        } else {
            this.innerBounds = new Rectangle(this.outerBounds.getX() + ext, this.innerBounds.getY(), this.outerBounds.getWidth() - ext, this.innerBounds.getHeight());
            this.span_1 = this.innerBounds.getX();
            this.span_2 = this.innerBounds.getX() + this.innerBounds.getWidth();
        }
    }

    int getExtent() {
        return this.extent;
    }

    void addLine(SceneGraph scene, int x, int y, boolean major, boolean horiz) {
        Line l1;
        int x2 = x;
        int x1 = x;
        int y2 = y;
        int y1 = y;
        int tick = major ? this.majorTick : this.minorTick;
        int main = this.drawingStyle & (major ? 256 : 512);
        if (main > 0) {
            if (horiz) {
                y1 = this.span_1;
                y2 = this.span_2;
            } else {
                x1 = this.span_1;
                x2 = this.span_2;
            }
            l1 = new Line(new Point(x1, y1), new Point(x2, y2), major ? this.majorGridLineStyle : this.minorGridLineStyle);
            l1.drawColor = major ? this.majorGridLineColor : this.minorGridLineColor;
            l1.drawThickness = major ? this.majorGridLineThickness : this.minorGridLineThickness;
            scene.add(l1);
        }
        if (tick > 0) {
            if (horiz) {
                y1 = this.axisLineStart.getY() - this.lineThickness / 2;
                y2 = y1 + tick;
            } else {
                x1 = this.axisLineStart.getX() + (this.lineThickness + 1) / 2 - 1;
                x2 = x1 - tick;
            }
            l1 = new Line(new Point(x1, y1), new Point(x2, y2));
            l1.drawThickness = major ? this.majorGridLineThickness : this.minorGridLineThickness;
            l1.drawColor = this.lineColor;
            scene.add(l1);
        }
    }

    void drawLine(SceneGraph scene) {
        Point p1 = new Point(this.axisLineStart);
        Point p2 = new Point(this.axisLineEnd);
        if (this.axisNumber == 0) {
            p1.translate(-this.lineThickness / 2, 0);
        } else {
            p1.translate(0, this.lineThickness / 2);
        }
        Line axLine = new Line(p1, p2, this.lineStyle);
        axLine.drawColor = this.lineColor;
        axLine.drawThickness = this.lineThickness;
        axLine.vert = this.axisNumber == 1;
        scene.add(axLine);
    }

    void addStyle(int st) {
        this.drawingStyle |= st;
    }

    void removeStyle(int st) {
        this.drawingStyle &= ~st;
    }

    void setStyle(int st) {
        this.drawingStyle = st;
    }

    void setStyle(int st, boolean set) {
        if (set && this.isVisible()) {
            this.addStyle(st);
        } else {
            this.removeStyle(st);
        }
    }
}

