/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer;
import oracle.bpm.chart.core.primitives.DataPoint;
import oracle.bpm.chart.core.primitives.Polygon;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.AreaChartAppearance;
import oracle.bpm.chart.resources.appearance.ChartAppearance;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.chart.shared.styles.LineStyle;
import oracle.bpm.draw.Color;
import oracle.bpm.geom.Point;

public class AreaLayer
extends ChartLayer {
    public AreaLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(14);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        int j;
        double val;
        DataPoint[] points;
        int j0;
        AreaChartAppearance areaApp = (AreaChartAppearance)this.getAppearance();
        Point topLeft = this.outerBounds.getOrigin();
        Point bottomRight = new Point(this.outerBounds.getX() + this.outerBounds.getWidth(), this.outerBounds.getY() + this.outerBounds.getHeight());
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        if (rowCount < 1 || colCount < 1) {
            return;
        }
        double dataMin = this.data.getDataMin();
        double dataMax = this.data.getDataMax();
        double zero = 0.0;
        if (dataMax < 0.0) {
            zero = dataMax;
        } else if (dataMin > 0.0) {
            zero = dataMin;
        }
        int anchor0 = areaApp.getLineStartCapStyle();
        int anchor1 = areaApp.getLineEndCapStyle();
        int anchorSize = areaApp.getMidPointAnchors();
        if (anchorSize <= 0) {
            anchor1 = -1;
            anchor0 = -1;
        } else if (anchor0 == 0) {
            anchor1 = anchor0;
        } else if (anchor0 == 1) {
            anchor1 = 10;
        } else {
            if (anchor0 < 2) {
                anchor0 = 2;
            }
            if (anchor0 > 10) {
                anchor0 = 10;
            }
            if (anchor1 < 2) {
                anchor1 = 2;
            }
            if (anchor1 > 10) {
                anchor1 = 10;
            }
        }
        int anchor = anchor0;
        if (anchor0 == 1) {
            anchor0 = 2;
            anchor = areaApp.randomAnchor;
        }
        boolean hitOne = areaApp.getCanSelectDataPointOnly();
        Polygon[] all = new Polygon[rowCount];
        double[] vals = new double[rowCount];
        double lastVal = 0.0;
        int cols = colCount - 1;
        if (cols <= 0) {
            cols = 1;
        }
        for (int row = 0; row < rowCount; ++row) {
            vals[row] = 0.0;
            j0 = 0;
            points = new DataPoint[colCount + 2];
            for (int col = 0; col < colCount; ++col) {
                Object dVal = this.data.getObjectValue(row, col);
                val = ChartDataAdapter.toDouble(dVal);
                if (val != val) continue;
                lastVal = lastVal >= 0.0 != val >= 0.0 ? val * 2.0 / 3.0 : val;
                int n = row;
                vals[n] = vals[n] + (val > 0.0 ? lastVal : -lastVal);
                points[j0] = new DataPoint(Axis.dataToPointLinearPlane(0.0, cols, dataMin, dataMax, topLeft, bottomRight, col, val), hitOne);
                points[j0].fillColor = this.colorModel.getFillColor(row, col, val);
                points[j0].drawColor = this.colorModel.getOutlineColor(row, col, val);
                points[j0].row = row;
                points[j0].column = col;
                points[j0].hitMe = true;
                ++j0;
            }
            if (j0 == 0) continue;
            if (j0 < colCount) {
                DataPoint[] points0 = new DataPoint[j0 + 2];
                j = j0;
                while (j-- > 0) {
                    points0[j] = points[j];
                }
                points = points0;
            }
            points[j0] = new DataPoint(Axis.dataToPointLinearPlane(0.0, cols, dataMin, dataMax, topLeft, bottomRight, cols, zero));
            points[j0 + 1] = new DataPoint(Axis.dataToPointLinearPlane(0.0, cols, dataMin, dataMax, topLeft, bottomRight, 0.0, zero));
            Polygon poly = new Polygon(points);
            poly.drawThickness = areaApp.getLineThickness();
            poly.lineStyle = new LineStyle(anchor, anchorSize, areaApp.getLineDrawStyle());
            poly.drawColor = this.colorModel.getOutlineColor(row, 0, 0.0);
            all[row] = poly;
            if (anchor0 > anchor1) {
                if (++anchor == anchor1) {
                    anchor = anchor0;
                    continue;
                }
                if (anchor <= 10) continue;
                anchor = 2;
                continue;
            }
            if (anchor0 >= anchor1 || ++anchor <= anchor1) continue;
            anchor = anchor0;
        }
        int alpha = ((ColorAppearance)this.component.getChartAppearance(6)).getAlphaLevel();
        int alphaLevel = rowCount < 2 ? 0 : areaApp.getTopLayerTransparency();
        anchor = 0;
        if (rowCount == 1) {
            scene.add(all[0]);
        } else {
            while (true) {
                val = -1.0;
                j = -1;
                for (int row = 0; row < rowCount; ++row) {
                    if (!(vals[row] > val)) continue;
                    j = row;
                    val = vals[row];
                }
                if (j < 0) break;
                if (all[j] != null) {
                    if (alphaLevel > 0) {
                        points = all[j].dataPoints;
                        j0 = points.length;
                        while (j0-- > 0) {
                            Color clr = points[j0].fillColor;
                            if (clr == null) continue;
                            points[j0].fillColor = Color.valueOf(clr.getRed(), clr.getGreen(), clr.getBlue(), alpha * (100 - alphaLevel * anchor / (rowCount - 1)) / 100);
                        }
                        ++anchor;
                    }
                    scene.add(all[j]);
                }
                vals[j] = -1.0;
            }
        }
    }
}

