/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.layers;

import oracle.bpm.chart.core.ChartCore;
import oracle.bpm.chart.core.SceneGraph;
import oracle.bpm.chart.core.layers.Axis;
import oracle.bpm.chart.core.layers.ChartLayer3D;
import oracle.bpm.chart.core.primitives.Face;
import oracle.bpm.chart.core.primitives.IFGOFF;
import oracle.bpm.chart.data.ChartDataAdapter;
import oracle.bpm.chart.resources.IChartComponent;
import oracle.bpm.chart.resources.appearance.ChartAppearance;

public class Area3DLayer
extends ChartLayer3D {
    public Area3DLayer(IChartComponent component, ChartCore core) {
        super(component, core);
    }

    @Override
    public ChartAppearance getAppearance() {
        return this.component.getChartAppearance(14);
    }

    @Override
    public void fillSceneGraph(SceneGraph scene) {
        super.fillSceneGraph(scene);
        int rowCount = this.data.getRowCount();
        int colCount = this.data.getColumnCount();
        double dataMin = this.data.getDataMin();
        double dataMax = this.data.getDataMax();
        double zero = 0.0;
        if (dataMax < 0.0) {
            zero = dataMax;
        } else if (dataMin > 0.0) {
            zero = dataMin;
        }
        int cols = colCount - 1;
        if (cols < 1) {
            cols = 1;
        }
        float yZero = (float)Axis.dataToDoubleLinear(dataMin, dataMax, 0.0, this.volume.y, zero);
        float zWidth = this.volume.z * 0.9f / (float)rowCount;
        float zZero = zWidth / 20.0f;
        int order0 = this.core.order;
        order0 = ChartCore.fixTop(order0);
        for (int ii = 0; ii < rowCount; ++ii) {
            int row = this.core.flipRow ? rowCount - 1 - ii : ii;
            for (int jj = 0; jj < colCount; ++jj) {
                int[] ids;
                int i0;
                boolean bLeftSide;
                int j;
                int col = j = this.core.flipCol ? colCount - 1 - jj : jj;
                int iNext = colCount == 1 || j + 1 >= colCount ? 0 : 1;
                Object dVal = this.data.getObjectValue(row, col);
                double val = ChartDataAdapter.toDouble(dVal);
                if (val != val) continue;
                double valNext = this.data.getValue(row, col + iNext);
                while (valNext != valNext && col + iNext + 1 < colCount) {
                    valNext = this.data.getValue(row, col + ++iNext);
                }
                boolean bRightSide = iNext == 0;
                boolean bl = bLeftSide = !bRightSide;
                if (j == 0) {
                    bLeftSide = true;
                } else if (this.core.flipCol) {
                    i0 = col;
                    while (i0-- > 0 && Double.isNaN(this.data.getValue(row, i0))) {
                    }
                    if (i0 < 0) {
                        bLeftSide = true;
                    }
                }
                if (j + iNext >= colCount - 1) {
                    bRightSide = true;
                }
                if (valNext != valNext) {
                    iNext = 0;
                    valNext = val;
                }
                IFGOFF result = new IFGOFF();
                result.column = col;
                result.row = row;
                result.nverts = 8;
                float x1 = (float)Axis.dataToDoubleLinear(0.0, cols, 0.0, this.volume.x, j);
                float y1 = (float)Axis.dataToDoubleLinear(dataMin, dataMax, 0.0, this.volume.y, val);
                float z = (float)Axis.dataToDoubleLinear(0.0, rowCount, 0.0, this.volume.z, row) + zZero;
                float x2 = (float)Axis.dataToDoubleLinear(0.0, cols, 0.0, this.volume.x, j + iNext);
                float y2 = (float)Axis.dataToDoubleLinear(dataMin, dataMax, 0.0, this.volume.y, valNext);
                float x3 = 0.0f;
                int order = order0;
                int bottom = 3;
                int[] id00 = null;
                int[] id01 = null;
                int[] id30 = null;
                int[] id31 = null;
                if (val != 0.0 || valNext != 0.0) {
                    if (val <= 0.0 && valNext <= 0.0) {
                        order = ChartCore.fixTop(ChartCore.swapTop(this.core.order));
                    } else if (val < 0.0 || valNext < 0.0) {
                        bottom = 0;
                        order = ChartCore.fixBot(order);
                        result.nverts = 10;
                        x3 = (float)((double)(x2 - x1) * val / (val - valNext));
                        if (x3 < 0.0f) {
                            x3 = -x3;
                        }
                        x3 += x1;
                        id00 = new int[]{5, 8, 9, 7};
                        id01 = new int[]{4, 8, 9, 6};
                        id30 = new int[]{8, 9, 3, 1};
                        id31 = new int[]{0, 2, 9, 8};
                        if (val > 0.0) {
                            ids = id00;
                            id00 = id01;
                            id01 = ids;
                            ids = id30;
                            id30 = id31;
                            id31 = ids;
                        }
                    }
                }
                result.vert = new float[]{x1, y1, z, x2, y2, z, x1, y1, z + zWidth, x2, y2, z + zWidth, x1, yZero, z, x2, yZero, z, x1, yZero, z + zWidth, x2, yZero, z + zWidth, x3, yZero, z, x3, yZero, z + zWidth};
                result.fillColor = this.colorModel.getFillColor(row, col, val);
                result.drawColor = this.colorModel.getOutlineColor(row, col, val);
                int skip = 4;
                int iAdd0 = -1;
                int iAdd3 = -1;
                if (bRightSide) {
                    ++skip;
                }
                if (bLeftSide) {
                    ++skip;
                }
                result.face = new Face[skip + 2 - (bottom & 2)];
                skip = 0;
                for (i0 = 0; i0 < 6; ++i0) {
                    boolean noFill = false;
                    int ii0 = order >> (5 - i0) * 4 & 7;
                    if (!bRightSide || !bLeftSide) {
                        if (bLeftSide) {
                            if (ii0 == 5) {
                                ++skip;
                                continue;
                            }
                        } else if (bRightSide) {
                            if (ii0 == 1) {
                                ++skip;
                                continue;
                            }
                        } else if (ii0 == 1 || ii0 == 5) {
                            ++skip;
                            continue;
                        }
                    }
                    if (i0 < 3 && ii0 != 3 && ii0 != bottom) {
                        noFill = true;
                    }
                    ids = ii0 == 0 ? (bottom == 3 ? new int[]{4, 5, 7, 6} : id00) : (ii0 == 1 ? new int[]{0, 4, 6, 2} : (ii0 == 2 ? new int[]{0, 1, 5, 4} : (ii0 == 3 ? (bottom == 3 ? new int[]{0, 2, 3, 1} : id30) : (ii0 == 4 ? new int[]{2, 6, 7, 3} : new int[]{1, 3, 7, 5}))));
                    result.face[i0 - skip] = new Face(ids, noFill ? -2 : ii0);
                    if (bottom != 0) continue;
                    if (ii0 == 0) {
                        iAdd3 = i0 - --skip;
                    }
                    if (ii0 != 3) continue;
                    iAdd0 = i0 - --skip;
                }
                if (iAdd0 >= 0) {
                    result.face[iAdd0] = new Face(id01, 0);
                }
                if (iAdd3 >= 0) {
                    result.face[iAdd3] = new Face(id31, 3);
                }
                scene.add(result);
            }
        }
    }
}

