/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.colormodel;

import oracle.bpm.chart.core.colormodel.SimpleColorModel;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.draw.Color;

public class RandomColorModel
extends SimpleColorModel {
    private transient int[] randomColors;

    public RandomColorModel(ColorAppearance app) {
        super(app);
        this.randomColors = app.getRandomColors();
    }

    @Override
    public Color getFillColor(int row, int col, double dataValue) {
        Color c;
        int iRow;
        if (row < 0) {
            row = 0;
        }
        if (col < 0) {
            col = 0;
        }
        if (this.swapRowCol) {
            iRow = row;
            row = col;
            col = iRow;
        }
        if ((c = this.getColor(row, col)) != null) {
            return c;
        }
        iRow = row;
        int iCol = col;
        int iCols = this.colCount;
        if (!this.colorByRow) {
            iRow = col;
            iCol = row;
            iCols = this.rowCount;
        }
        int rgb = this.randomColors[iRow % this.randomColors.length];
        return this.setColor(this.scaleColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, iCol, iCols > 1 ? iCols - 1 : 1), row, col);
    }
}

