/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.colormodel;

import oracle.bpm.chart.core.colormodel.SimpleColorModel;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.draw.Color;

public class LinearColorModel
extends SimpleColorModel {
    public LinearColorModel(ColorAppearance app) {
        super(app);
    }

    @Override
    public Color getFillColor(int row, int col, double dataValue) {
        Color c;
        int iRow;
        if (row < 0) {
            row = 0;
        }
        if (col < 0) {
            col = 0;
        }
        if (this.swapRowCol) {
            iRow = row;
            row = col;
            col = iRow;
        }
        if ((c = this.getColor(row, col)) != null) {
            return c;
        }
        int r = this.colorStart.getRed();
        int g = this.colorStart.getGreen();
        int b = this.colorStart.getBlue();
        iRow = row;
        int iCol = col;
        int iRows = this.rowCount;
        int iCols = this.colCount;
        if (!this.colorByRow) {
            iRow = col;
            iCol = row;
            iRows = this.colCount;
            iCols = this.rowCount;
        }
        if (--iRows > 0) {
            r += iRow * (this.colorEnd.getRed() - r) / iRows;
            g += iRow * (this.colorEnd.getGreen() - g) / iRows;
            b += iRow * (this.colorEnd.getBlue() - b) / iRows;
            if (r < 0) {
                r = 0;
            }
            if (r > 255) {
                r = 255;
            }
            if (g < 0) {
                g = 0;
            }
            if (g > 255) {
                g = 255;
            }
            if (b < 0) {
                b = 0;
            }
            if (b > 255) {
                b = 255;
            }
        }
        return this.setColor(this.scaleColor(r, g, b, iCol, iCols > 1 ? iCols - 1 : 1), row, col);
    }
}

