/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.chart.core.colormodel;

import oracle.bpm.chart.core.colormodel.SimpleColorModel;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.draw.Color;

public class CustomColorModel
extends SimpleColorModel {
    private transient boolean colorArrayRandom = false;
    private transient Color[] customPalette;

    public CustomColorModel(ColorAppearance app) {
        super(app);
        this.customPalette = app.getCustomPalette();
        if (this.customPalette != null && this.customPalette.length == 0) {
            this.customPalette = null;
        }
        this.colorArrayRandom = app.getModelStyle() == 5;
    }

    @Override
    public Color getFillColor(int row, int col, double dataValue) {
        Color c;
        int iRow;
        if (this.customPalette == null) {
            return Color.WHITE;
        }
        if (row < 0) {
            row = 0;
        }
        if (col < 0) {
            col = 0;
        }
        if (this.swapRowCol) {
            iRow = row;
            row = col;
            col = iRow;
        }
        if ((c = this.getColor(row, col)) != null) {
            return c;
        }
        iRow = row;
        int iCol = col;
        int iCols = this.colCount;
        if (!this.colorByRow) {
            iRow = col;
            iCol = row;
            iCols = this.rowCount;
        }
        if (this.colorArrayRandom && this.randomScale != null) {
            iRow = this.randomScale.length + this.randomScale[iRow % this.randomScale.length];
        }
        return this.setColor(this.scaleColor(this.customPalette[iRow % this.customPalette.length], iCol, iCols > 1 ? iCols - 1 : 1), row, col);
    }
}

